/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class IsolatedClassLoaderBuilder {
    private final List<File> directories = new ArrayList<File>();
    private final List<File> files = new ArrayList<File>();
    private final List<File> recursiveDirectories = new ArrayList<File>();
    private final List<String> fallThroughPackages = new ArrayList<String>();
    private final List<String> nonFallThroughPackages = new ArrayList<String>();
    private static final Logger logger = Logger.getLogger((String)"dku.utils.classloader");

    public IsolatedClassLoaderBuilder withFallThroughPackages(List<String> packages) {
        Preconditions.checkNotNull(packages, (Object)"packages name cannot be null");
        for (String packageName : packages) {
            Preconditions.checkNotNull((Object)packageName, (Object)"Package name cannot be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)packageName), (Object)"Package name cannot be empty or blank");
            this.fallThroughPackages.add(packageName);
        }
        return this;
    }

    public IsolatedClassLoaderBuilder withNonFallThroughPackages(List<String> packages) {
        Preconditions.checkNotNull(packages, (Object)"packages name cannot be null");
        for (String packageName : packages) {
            Preconditions.checkNotNull((Object)packageName, (Object)"Package name cannot be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)packageName), (Object)"Package name cannot be empty or blank");
            this.nonFallThroughPackages.add(packageName);
        }
        return this;
    }

    public IsolatedClassLoaderBuilder withJarsInRecursiveDir(File directory) {
        Preconditions.checkNotNull((Object)directory);
        this.recursiveDirectories.add(directory);
        return this;
    }

    public IsolatedClassLoaderBuilder withJarsInRecursiveDir(String path) {
        return this.withJarsInRecursiveDir(new File(path));
    }

    public IsolatedClassLoaderBuilder withJarsInDir(File directory) {
        Preconditions.checkNotNull((Object)directory);
        this.directories.add(directory);
        return this;
    }

    public IsolatedClassLoaderBuilder withJarsInDir(String path) {
        return this.withJarsInDir(new File(path));
    }

    public IsolatedClassLoaderBuilder withJarFile(File file) {
        Preconditions.checkNotNull((Object)file);
        this.files.add(file);
        return this;
    }

    public IsolatedClassLoaderBuilder withJarFile(String path) {
        return this.withJarFile(new File(path));
    }

    public URLClassLoader build() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : this.getFiles()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("Path " + file.getAbsolutePath() + " could not be transformed into URL"), (Throwable)e);
            }
        }
        return new IsolatedClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader(), this.fallThroughPackages, this.nonFallThroughPackages);
    }

    private List<File> getFiles() throws IOException {
        final ArrayList<File> deps = new ArrayList<File>();
        for (File directoryFile : this.recursiveDirectories) {
            if (directoryFile.exists()) {
                Files.walkFileTree(directoryFile.toPath(), new HashSet<FileVisitOption>(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.toString().endsWith(".jar")) {
                            deps.add(file.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            logger.warn((Object)("Path " + directoryFile.getPath() + " doesn't exist"));
        }
        for (File directory : this.directories) {
            if (directory.exists() && directory.isDirectory()) {
                deps.add(directory);
                continue;
            }
            logger.warn((Object)("Path " + directory.getPath() + " doesn't exist or is not a directory"));
        }
        for (File file : this.files) {
            if (file.exists()) {
                deps.add(file);
                continue;
            }
            logger.warn((Object)("Path " + file.getPath() + " doesn't exist"));
        }
        return deps;
    }

    private static class IsolatedClassLoader
    extends URLClassLoader {
        private final List<String> fallThroughPackages;
        private final List<String> nonFallThroughPackages;

        public IsolatedClassLoader(URL[] classpath, ClassLoader parent, List<String> fallThroughPackages, List<String> nonFallThroughPackages) {
            super(classpath, parent);
            this.fallThroughPackages = fallThroughPackages;
            this.nonFallThroughPackages = nonFallThroughPackages;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c2 = this.findLoadedClass(name);
            if (c2 == null) {
                if (this.isPartOfFallThroughPackage(name)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Loading class " + name + " directly via parent classloader as it part of a fall-through package"));
                    }
                    c2 = super.loadClass(name, resolve);
                } else {
                    try {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Loading class " + name));
                        }
                        c2 = this.findClass(name);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Class " + name + " loaded from classloader"));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Class " + name + " not found in classloader, loading it from parent classloader"));
                        }
                        c2 = super.loadClass(name, resolve);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(c2);
            }
            return c2;
        }

        @Override
        public URL getResource(String name) {
            URL url = this.findResource(name);
            if (url == null) {
                url = super.getResource(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> urls = new ArrayList<URL>(IsolatedClassLoader.toList(this.findResources(name)));
            ClassLoader parent = this.getParent();
            if (parent != null) {
                urls.addAll(IsolatedClassLoader.toList(parent.getResources(name)));
            }
            return Collections.enumeration(urls);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isPartOfFallThroughPackage(String name) {
            if (!this.fallThroughPackages.stream().anyMatch(name::startsWith)) return false;
            if (this.nonFallThroughPackages.stream().anyMatch(name::startsWith)) return false;
            return true;
        }

        private static List<URL> toList(Enumeration<URL> items) {
            return items != null ? Collections.list(items) : Collections.emptyList();
        }
    }
}

