/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Object getFieldValue(Object obj, String fieldName) throws ReflectiveOperationException {
        return ReflectionUtils.getField(obj.getClass(), fieldName).get(obj);
    }

    public static Field getField(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ReflectionUtils.getField(superclass, fieldName);
            }
            throw e;
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName, boolean arg) throws ReflectiveOperationException {
        Method method = ReflectionUtils.getMethod(obj.getClass(), methodName, Boolean.TYPE);
        return (T)method.invoke(obj, arg);
    }

    public static <T> T invokeMethod(Class<T> returnType, Object obj, String methodName, Object ... args) throws ReflectiveOperationException {
        Class[] argsTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsTypes[i] = args[i].getClass();
        }
        Method method = ReflectionUtils.getMethod(obj.getClass(), methodName, argsTypes);
        return (T)method.invoke(obj, args);
    }

    public static Object invokeMethod(Object obj, String methodName, Object ... args) throws ReflectiveOperationException {
        return ReflectionUtils.invokeMethod(Object.class, obj, methodName, args);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws ReflectiveOperationException {
        try {
            Method field = clazz.getDeclaredMethod(methodName, parameterTypes);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ReflectionUtils.getMethod(superclass, methodName, parameterTypes);
            }
            throw e;
        }
    }
}

