/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.workspaces;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.DashboardsScreenshotsService;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.datastory.DatastoryIntegrationService;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceCreatedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceDatastoryChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceDeletedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceInvitationChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceLinkChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceMembershipChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceUpdatedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.com.google.common.io.ByteStreams;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspacesService {
    private static final String[] WORKSPACE_STOCK_COLORS = new String[]{"#540d6e", "#ee4266", "#ffd23f", "#3bceac", "#43aa8b", "#118ab2", "#073b4c"};
    @Autowired
    private WorkspacesDAO workspacesDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private IWorkspacePermissionsService permissionsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private DatastoryIntegrationService dataStoryService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    private DashboardsScreenshotsService dashboardsScreenshotsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.workspaces");

    public static boolean isValidWorkspaceKey(String workspaceKey) {
        return workspaceKey.matches("^[A-Za-z0-9_]+$");
    }

    public List<String> listWorkspaceKeys() throws IOException {
        return this.workspacesDAO.listWorkspaceKeys();
    }

    public List<Workspace> listWorkspaces() throws IOException {
        return this.workspacesDAO.listWorkspaces();
    }

    public List<Workspace> listWorkspacesUnsafe() throws IOException {
        return this.workspacesDAO.listWorkspacesUnsafe();
    }

    public List<Workspace> listAccessibleWorkspacesUnsafe(AuthCtx authCtx) throws IOException {
        return this.listAccessibleWorkspacesUnsafe(authCtx, Privileges.WorkspaceLevelPrivilegeType.READ);
    }

    public List<Workspace> listAccessibleWorkspacesUnsafe(AuthCtx authCtx, Privileges.WorkspaceLevelPrivilegeType accessLevel) throws IOException {
        Preconditions.checkNotNull((Object)((Object)accessLevel), (Object)"accessLevel");
        return this.listWorkspacesUnsafe().stream().filter(wks -> {
            try {
                return this.permissionsService.hasWorkspacePrivileges(authCtx, (Workspace)wks, accessLevel);
            }
            catch (DKUSecurityException e) {
                logger.errorV((Throwable)e, "Ignoring workspace %s as we failed to retrieve the configured permissions", new Object[]{wks.workspaceKey});
                return false;
            }
        }).collect(Collectors.toList());
    }

    public void checkPerm(AuthCtx authCtx, String workspaceKey, Privileges.WorkspaceLevelPrivilegeType ... privileges) throws DKUSecurityException {
        this.permissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, privileges);
    }

    public Workspace getWorkspace(AuthCtx authCtx, String workspaceKey) throws IOException {
        return this.getWorkspace(authCtx, workspaceKey, true, true);
    }

    public Workspace getWorkspace(AuthCtx authCtx, String workspaceKey, boolean enrichPermissions, boolean enrichObjects) throws IOException {
        return this.enrichWorkspace(authCtx, this.workspacesDAO.getOrNull(workspaceKey), enrichPermissions, enrichObjects);
    }

    public Workspace getRawWorkspaceUnsafe(String workspaceKey) throws IOException {
        return this.workspacesDAO.getOrNullUnsafe(workspaceKey);
    }

    public Workspace getMandatoryWorkspace(String workspaceKey) throws IOException {
        return this.workspacesDAO.getMandatory(workspaceKey);
    }

    public boolean hasWorkspace(String workspaceKey) throws IOException {
        return this.workspacesDAO.getOrNull(workspaceKey) != null;
    }

    public void createWorkspace(AuthCtx user, Workspace workspace) throws IOException, DKUSecurityException {
        String userId;
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((String)workspace.workspaceKey) ? 1 : 0) != 0, (Object)"workspaceKey cannot be null or empty");
        Preconditions.checkArgument((!this.hasWorkspace(workspace.workspaceKey) ? 1 : 0) != 0, (Object)"A workspace with the specified key already exists.");
        if (StringUtils.isBlank((String)workspace.description)) {
            String userDisplayName = user.getAssociatedDSSUser() != null ? this.usersService.getPublicUser((String)user.getAssociatedDSSUser()).displayName : user.getIdentifier();
            workspace.description = "The workspace " + workspace.getDisplayName() + " was created by " + userDisplayName + " on " + ProjectsService.getDateForShortDesc();
        }
        if (StringUtils.isBlank((String)workspace.color) || !workspace.color.startsWith("#")) {
            workspace.color = WORKSPACE_STOCK_COLORS[Math.abs(workspace.workspaceKey.hashCode() % WORKSPACE_STOCK_COLORS.length)];
        }
        if (workspace.permissions == null) {
            workspace.permissions = new ArrayList<BasePermissions.PermissionItem>();
        }
        if (!WorkspacesService.isAdmin(userId = user.getIdentifier(), workspace)) {
            workspace.permissions.add(BasePermissions.PermissionItem.ofUser(userId, true, true, true));
        }
        if (workspace.workspaceObjects != null) {
            for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
                workspaceObject.id = this.generateWorkspaceObjectId(workspaceObject);
            }
        }
        this.pubSub.publishAfterTransaction(this.buildCreateEvent(user, workspace));
        this.saveAndCheckPermissions(user, workspace);
    }

    public void checkAllUserGroupCanBeAdded(Workspace workspace) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
        if (workspace.permissions.stream().anyMatch(p -> StringUtils.isNotBlank((String)p.group) && p.group.equals("$$ALL_USERS$$")) && gs.security.restrictUsersAndGroupsVisibility) {
            throw new DKUSecurityException("You cannot add the 'All users' group due to the general settings of your instance.");
        }
    }

    public void updateWorkspace(AuthCtx authCtx, Workspace workspace) throws IOException, DKUSecurityException {
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((String)workspace.workspaceKey) ? 1 : 0) != 0, (Object)"workspaceKey cannot be null or empty");
        Preconditions.checkArgument((boolean)this.hasWorkspace(workspace.workspaceKey), (Object)"Workspace does not exists.");
        this.saveAndCheckPermissions(authCtx, workspace);
    }

    public void saveAndCheckPermissions(AuthCtx authCtx, Workspace workspace) throws IOException, DKUSecurityException {
        this.checkAllUserGroupCanBeAdded(workspace);
        this.convertWorkspacePendingUserEmailPermissionsIfMatchingUser(workspace);
        this.resolveInvitationEmailStatuses(workspace);
        workspace.permissions = WorkspacesService.squashPermissions(workspace.permissions);
        if (workspace.permissions.stream().noneMatch(permission -> (permission.user != null || permission.group != null) && permission.admin)) {
            throw new ApplicativeException("Configuration error", "A workspace must have at least one administrator.");
        }
        this.publishChangeEvents(authCtx, workspace);
        this.workspacesDAO.save(workspace);
    }

    public void deleteWorkspace(String workspaceKey) throws IOException {
        Preconditions.checkArgument((!StringUtils.isBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"workspaceKey cannot be null or empty");
        Preconditions.checkArgument((boolean)this.hasWorkspace(workspaceKey), (Object)"Workspace does not exists.");
        this.workspacesDAO.delete(workspaceKey);
        this.pubSub.publishAfterTransaction(this.buildDeleteEvent(workspaceKey));
    }

    public Workspace.WorkspaceObject getWorkspaceObjectMandatory(AuthCtx authCtx, String workspaceKey, Workspace.WorkspaceObject objectKey) throws Exception {
        Workspace workspace = this.workspacesDAO.getMandatory(workspaceKey);
        int index = workspace.workspaceObjects.indexOf(objectKey);
        if (index < 0) {
            throw new NotFoundException("Object does not exist in the workspace");
        }
        Workspace.WorkspaceObject workspaceObject = workspace.workspaceObjects.get(index);
        if (workspaceObject.appId != null) {
            this.appsService.checkAppInstantiatePerm_T(authCtx, workspaceObject.appId);
        }
        this.enrichWorkspaceObject(authCtx, workspaceKey, workspaceObject);
        return workspaceObject;
    }

    public String addObject(AuthCtx authCtx, String workspaceKey, Workspace.WorkspaceObject workspaceObject) throws Exception {
        return this.addObjects(authCtx, workspaceKey, Collections.singletonList(workspaceObject)).get(0);
    }

    public List<String> addObjects(AuthCtx authCtx, String workspaceKey, List<Workspace.WorkspaceObject> workspaceObjects) throws Exception {
        return this.addObjects(authCtx, this.workspacesDAO.getMandatory(workspaceKey), workspaceObjects);
    }

    public List<String> addObjects(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        boolean dirty = false;
        HashSet<TaggableObjectsService.TaggableObjectRef> newDashboardRefs = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        ArrayList<TaggableObjectsService.TaggableObjectRef> objectsToAuthorize = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        for (Workspace.WorkspaceObject workspaceObject : workspaceObjects) {
            Optional<Workspace.WorkspaceObject> existingObject;
            if (workspaceObject.reference != null && StringUtils.isBlank((String)workspaceObject.reference.workspaceKey)) {
                workspaceObject.reference = new TaggableObjectsService.TaggableObjectRef(workspaceObject.reference.projectKey, workspaceObject.reference.type, workspaceObject.reference.id, workspace.workspaceKey);
            }
            if ((existingObject = workspace.workspaceObjects.stream().filter(w -> w.equals(workspaceObject)).findAny()).isEmpty()) {
                workspaceObject.id = this.generateWorkspaceObjectId(workspaceObject);
                result.add(workspaceObject.id);
                workspace.workspaceObjects.add(workspaceObject);
                dirty = true;
                TaggableObjectsService.TaggableObjectRef objectRef = workspaceObject.reference;
                if (objectRef != null) {
                    objectsToAuthorize.add(objectRef);
                    this.pubSub.publishAfterTransaction(this.buildShareEvent(objectRef, authCtx, workspace.workspaceKey, WorkspacesService.workspaceDetails(workspace)));
                    this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectAddedEvent(objectRef, authCtx, workspace.workspaceKey));
                    if (objectRef.type != ITaggingService.TaggableType.DASHBOARD) continue;
                    newDashboardRefs.add(objectRef);
                    continue;
                }
                if (workspaceObject.appId != null) {
                    if (!workspaceObject.appId.startsWith("PROJECT_")) continue;
                    String projectKey = workspaceObject.appId.substring("PROJECT_".length());
                    this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectAddedEvent(new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey), authCtx, workspace.workspaceKey));
                    continue;
                }
                if (workspaceObject.htmlLink != null) {
                    this.pubSub.publishAfterTransaction(this.buildWorkspaceLinkEvent(authCtx, workspace.workspaceKey, workspaceObject.htmlLink, WorkspaceObjectChangedEvent.ActionCategory.ADDED));
                    continue;
                }
                if (workspaceObject.story == null) continue;
                this.pubSub.publishAfterTransaction(this.buildDatastoryObjectCreatedEvent(authCtx, workspace.workspaceKey, workspaceObject.story));
                continue;
            }
            result.add(existingObject.get().id);
        }
        if (dirty) {
            if (!objectsToAuthorize.isEmpty()) {
                this.addObjectsAuthorizations(objectsToAuthorize);
            }
            this.workspacesDAO.save(workspace);
            this.dashboardsScreenshotsService.buildScreenshotsIfNeeded(authCtx, newDashboardRefs);
        }
        return result;
    }

    public void createDatastories(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        for (Workspace.WorkspaceObject workspaceObject : workspaceObjects) {
            if (workspaceObject == null || workspaceObject.story == null || workspaceObject.story.id != null) continue;
            this.licenseEnforcementService.checkWriteStoriesAllowed(authCtx);
            this.checkDatasetsExist(workspace, workspaceObject.story);
            workspaceObject.story.id = this.dataStoryService.create(authCtx, workspace, workspaceObject.story);
        }
    }

    public void duplicateDatastories(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        for (Workspace.WorkspaceObject workspaceObject : workspaceObjects) {
            if (workspaceObject == null || workspaceObject.story == null) continue;
            this.licenseEnforcementService.checkWriteStoriesAllowed(authCtx);
            this.checkDatastoryExist(workspace, workspaceObject.story.id);
            workspaceObject.story.id = this.dataStoryService.duplicate(authCtx, workspace, workspaceObject.story.id, workspaceObject.story.title);
        }
    }

    public void updateDatastory(DSSAuthCtx authCtx, Workspace workspace, Workspace.WorkspaceObject workspaceObject) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        if (workspaceObject != null && workspaceObject.story != null) {
            this.licenseEnforcementService.checkWriteStoriesAllowed(authCtx);
            this.checkDatastoryExist(workspace, workspaceObject.story.id);
            this.dataStoryService.update(authCtx, workspace, workspaceObject.story);
        }
    }

    private void checkDatastoryExist(Workspace workspace, String storyId) throws NotFoundException {
        Workspace.WorkspaceObject existingStory = WorkspacesService.findObjectWithId(workspace, storyId);
        if (existingStory == null || existingStory.story == null) {
            throw new NotFoundException(String.format("Story with id %s cannot be found in the workspace", storyId));
        }
        this.checkDatasetsExist(workspace, existingStory.story);
    }

    private void checkDatasetsExist(Workspace workspace, Workspace.Story story) throws NotFoundException {
        Set workspaceDatasetsIds = workspace.workspaceObjects.stream().filter(wo -> wo.reference != null).map(wo -> wo.id).collect(Collectors.toSet());
        for (String reference : story.references) {
            if (workspaceDatasetsIds.contains(reference)) continue;
            throw new NotFoundException(String.format("Workspace object with id %s cannot be found in the workspace", reference));
        }
    }

    public void notifyProjectDeleted(AuthCtx authCtx, String projectKey) throws IOException {
        for (Workspace workspace : this.workspacesDAO.listWorkspaces()) {
            boolean dirty = false;
            Iterator<Workspace.WorkspaceObject> iterator = workspace.workspaceObjects.iterator();
            while (iterator.hasNext()) {
                Workspace.WorkspaceObject workspaceObject = iterator.next();
                if (workspaceObject.reference == null || !Objects.equals(workspaceObject.reference.projectKey, projectKey)) continue;
                this.publishObjectChangedEvent(authCtx, workspaceObject, workspace.workspaceKey, WorkspaceObjectChangedEvent.ActionCategory.DELETED);
                iterator.remove();
                dirty = true;
            }
            if (!dirty) continue;
            this.workspacesDAO.save(workspace);
        }
    }

    public boolean removeObjects(AuthCtx authCtx, String workspaceKey, List<Workspace.WorkspaceObject> workspaceObjects) throws IOException {
        Workspace workspace = this.workspacesDAO.getMandatory(workspaceKey);
        return this.removeObjects(authCtx, workspace, workspaceObjects);
    }

    public boolean removeObjects(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects) throws IOException {
        return this.removeObjects(authCtx, workspace, workspaceObjects, WorkspaceObjectChangedEvent.ActionCategory.REMOVED);
    }

    public void notifyObjectDeleted(AuthCtx authCtx, TaggableObjectsService.TaggableObjectRef objectRef) throws IOException {
        for (Workspace workspace : this.workspacesDAO.listWorkspaces()) {
            this.removeObjects(authCtx, workspace, Collections.singletonList(new Workspace.WorkspaceObject(new TaggableObjectsService.TaggableObjectRef(objectRef, workspace.workspaceKey))), WorkspaceObjectChangedEvent.ActionCategory.DELETED);
        }
    }

    public void notifyApplicationDeleted(AuthCtx authCtx, String applicationId) throws IOException {
        for (Workspace workspace : this.workspacesDAO.listWorkspaces()) {
            this.removeObjects(authCtx, workspace, Collections.singletonList(new Workspace.WorkspaceObject(applicationId)), WorkspaceObjectChangedEvent.ActionCategory.DELETED);
        }
    }

    private boolean removeObjects(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjectsToRemove, WorkspaceObjectChangedEvent.ActionCategory reason) throws IOException {
        boolean dirty = false;
        for (Workspace.WorkspaceObject workspaceObjectToRemove : workspaceObjectsToRemove) {
            Workspace.WorkspaceObject workspaceObjectToRemoveFound = WorkspacesService.findObjectWithId(workspace, workspaceObjectToRemove.id);
            if (workspaceObjectToRemoveFound == null) continue;
            workspace.workspaceObjects.remove(workspaceObjectToRemoveFound);
            this.removeFromDatastories(workspace, workspaceObjectToRemoveFound);
            this.publishObjectChangedEvent(authCtx, workspaceObjectToRemoveFound, workspace.workspaceKey, reason);
            dirty = true;
        }
        if (dirty) {
            this.workspacesDAO.save(workspace);
            return true;
        }
        return false;
    }

    private boolean removeObject(AuthCtx authCtx, Workspace workspace, String workspaceObjectId, WorkspaceObjectChangedEvent.ActionCategory reason) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workspaceObjectId), (Object)"workspaceObjectId cannot be null or empty");
        Workspace.WorkspaceObject objectToRemove = WorkspacesService.findObjectWithId(workspace, workspaceObjectId);
        if (objectToRemove != null) {
            workspace.workspaceObjects.remove(objectToRemove);
            this.removeFromDatastories(workspace, objectToRemove);
            this.publishObjectChangedEvent(authCtx, objectToRemove, workspace.workspaceKey, reason);
            this.workspacesDAO.save(workspace);
            return true;
        }
        return false;
    }

    private void removeFromDatastories(Workspace workspace, Workspace.WorkspaceObject workspaceObjectToRemove) {
        for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
            if (workspaceObject.story == null) continue;
            workspaceObject.story.references.remove(workspaceObjectToRemove.id);
        }
    }

    private void publishObjectChangedEvent(AuthCtx authCtx, Workspace.WorkspaceObject workspaceObject, String workspaceKey, WorkspaceObjectChangedEvent.ActionCategory reason) {
        if (workspaceObject.reference != null) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectChangeEvent(workspaceObject.reference, authCtx, workspaceKey, reason));
        } else if (workspaceObject.appId != null) {
            if (workspaceObject.appId.startsWith("PROJECT_")) {
                String projectKey = workspaceObject.appId.substring("PROJECT_".length());
                this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectChangeEvent(new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey), authCtx, workspaceKey, reason));
            }
        } else if (workspaceObject.htmlLink != null) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceLinkEvent(authCtx, workspaceKey, workspaceObject.htmlLink, reason));
        } else if (workspaceObject.story != null) {
            this.pubSub.publishAfterTransaction(this.buildDatastoryObjectRemovedEvent(authCtx, workspaceKey, workspaceObject.story));
        }
    }

    public void deleteDatastories(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects) throws IOException, DKUSecurityException {
        this.deleteDatastories(authCtx, workspace, workspaceObjects, false);
    }

    public void deleteDatastories(AuthCtx authCtx, Workspace workspace, List<Workspace.WorkspaceObject> workspaceObjects, boolean forceAllDelete) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        for (Workspace.WorkspaceObject workspaceObject : workspaceObjects) {
            if (workspaceObject == null || workspaceObject.story == null || WorkspacesService.findObjectWithId(workspace, workspaceObject.story.id) == null) continue;
            try {
                this.dataStoryService.delete(authCtx, workspaceObject.story.id);
            }
            catch (Exception e) {
                if (!forceAllDelete) {
                    throw e;
                }
                logger.warn((Object)("Cannot delete story: " + workspaceObject.story.id), (Throwable)e);
            }
        }
    }

    public List<String> listAllWorkspacesContainingObject(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException {
        return (List)this.listWorkspacesUnsafe().stream().filter(wks -> objectId == null || wks.contains(projectKey, objectType, objectId)).map(wks -> wks.workspaceKey).collect(ImmutableList.toImmutableList());
    }

    public boolean hasWorkspacesContainingObject(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException {
        for (Workspace workspace : this.listWorkspaces()) {
            if (!workspace.contains(projectKey, objectType, objectId)) continue;
            return true;
        }
        return false;
    }

    public void renameObjects(String workspaceKey, String projectKey, String oldName, String newName) throws IOException {
        Workspace workspace = this.workspacesDAO.getMandatory(workspaceKey);
        workspace.workspaceObjects.stream().filter(workspaceObject -> workspaceObject.reference != null && projectKey.equals(workspaceObject.reference.projectKey) && oldName.equals(workspaceObject.reference.id)).forEach(workspaceObject -> {
            TaggableObjectsService.TaggableObjectRef oldDataset = workspaceObject.reference;
            workspaceObject.reference = new TaggableObjectsService.TaggableObjectRef(oldDataset.projectKey, oldDataset.type, newName, oldDataset.workspaceKey);
        });
        this.workspacesDAO.save(workspace);
    }

    private void addObjectsAuthorizations(List<TaggableObjectsService.TaggableObjectRef> objectRefs) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        HashMultimap objectsToAuthorizePerProject = HashMultimap.create();
        for (TaggableObjectsService.TaggableObjectRef objectRef : objectRefs) {
            if (objectRef.type == ITaggingService.TaggableType.DASHBOARD) continue;
            objectsToAuthorizePerProject.put((Object)objectRef.projectKey, (Object)objectRef);
        }
        for (String projectKey : objectsToAuthorizePerProject.keySet()) {
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            List objectsToAuthorize = objectsToAuthorizePerProject.get((Object)projectKey).stream().filter(tor -> !WorkspacesService.isObjectAuthorized(tor, project.dashboardAuthorizations, SerializedProject.ReaderAuthorization.Mode.READ)).collect(Collectors.toList());
            if (objectsToAuthorize.isEmpty()) continue;
            for (TaggableObjectsService.TaggableObjectRef objectRef : objectsToAuthorize) {
                Optional<SerializedProject.ReaderAuthorization> authorization = WorkspacesService.getDashboardAuthorization(objectRef, project.dashboardAuthorizations);
                if (authorization.isPresent()) {
                    authorization.get().makeReadable();
                    continue;
                }
                project.dashboardAuthorizations.authorizations.add(SerializedProject.ReaderAuthorization.newReadAuthorization(new SmartObjectRef(null, objectRef.type, objectRef.id)));
            }
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
        }
    }

    private void publishChangeEvents(AuthCtx authCtx, Workspace workspace) throws IOException {
        List<String> removedPendingEmails;
        Workspace existingWorkspace = this.workspacesDAO.getOrNullUnsafe(workspace.workspaceKey);
        for (Workspace.WorkspaceObject workspaceObject : this.differenceObjects(existingWorkspace, workspace)) {
            if (workspaceObject.reference != null) {
                this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectAddedEvent(workspaceObject.reference, authCtx, workspace.workspaceKey));
                continue;
            }
            if (workspaceObject.htmlLink == null) continue;
            this.pubSub.publishAfterTransaction(this.buildWorkspaceLinkEvent(authCtx, workspace.workspaceKey, workspaceObject.htmlLink, WorkspaceObjectChangedEvent.ActionCategory.ADDED));
        }
        for (Workspace.WorkspaceObject workspaceObject : this.differenceObjects(workspace, existingWorkspace)) {
            if (workspaceObject.reference != null) {
                this.pubSub.publishAfterTransaction(this.buildWorkspaceObjectRemovedEvent(workspaceObject.reference, authCtx, workspace.workspaceKey));
                continue;
            }
            if (workspaceObject.htmlLink == null) continue;
            this.pubSub.publishAfterTransaction(this.buildWorkspaceLinkEvent(authCtx, workspace.workspaceKey, workspaceObject.htmlLink, WorkspaceObjectChangedEvent.ActionCategory.REMOVED));
        }
        List<String> newPendingEmails = this.getPendingUserEmailDifference(existingWorkspace, workspace);
        if (!newPendingEmails.isEmpty()) {
            String actor = authCtx != null ? authCtx.getIdentifier() : null;
            this.pubSub.publishAfterTransaction(new WorkspaceInvitationChangedEvent(WorkspaceInvitationChangedEvent.ActionType.CREATED, actor, workspace.workspaceKey, newPendingEmails));
        }
        if (!(removedPendingEmails = this.getPendingUserEmailDifference(workspace, existingWorkspace)).isEmpty()) {
            String actor = authCtx != null ? authCtx.getIdentifier() : null;
            this.pubSub.publishAfterTransaction(new WorkspaceInvitationChangedEvent(WorkspaceInvitationChangedEvent.ActionType.DELETED, actor, workspace.workspaceKey, removedPendingEmails));
        }
        for (String user : this.getUserDifference(existingWorkspace, workspace)) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceUserAddedEvent(authCtx, user, null, workspace.workspaceKey));
        }
        for (String user : this.getUserDifference(workspace, existingWorkspace)) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceUserOrGroupRemovedEvent(authCtx, user, null, workspace.workspaceKey));
        }
        for (String group : this.getGroupDifference(existingWorkspace, workspace)) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceUserAddedEvent(authCtx, null, group, workspace.workspaceKey));
        }
        for (String group : this.getGroupDifference(workspace, existingWorkspace)) {
            this.pubSub.publishAfterTransaction(this.buildWorkspaceUserOrGroupRemovedEvent(authCtx, null, group, workspace.workspaceKey));
        }
        if (!(existingWorkspace == null || Objects.equals(workspace.displayName, existingWorkspace.displayName) && Objects.equals(workspace.color, existingWorkspace.color) && Objects.equals(workspace.description, existingWorkspace.description) && Objects.equals(workspace.shortDesc, existingWorkspace.shortDesc) && Objects.equals(workspace.tags, existingWorkspace.tags))) {
            this.pubSub.publishAfterTransaction(this.buildUpdateEvent(authCtx, workspace));
        }
    }

    private DSSEvent buildWorkspaceUserOrGroupRemovedEvent(AuthCtx authCtx, String user, String group, String workspaceKey) {
        String actor = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceMembershipChangedEvent(workspaceKey, actor, user, group, WorkspaceMembershipChangedEvent.ActionType.REMOVED);
    }

    private DSSEvent buildWorkspaceUserAddedEvent(AuthCtx authCtx, String user, String group, String workspaceKey) {
        String actor = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceMembershipChangedEvent(workspaceKey, actor, user, group, WorkspaceMembershipChangedEvent.ActionType.ADDED);
    }

    private List<String> getUserDifference(@Nullable Workspace existingWorkspace, @Nullable Workspace workspace) {
        if (existingWorkspace == null || workspace == null) {
            return new ArrayList<String>();
        }
        List existingUsers = existingWorkspace.permissions.stream().filter(p -> p.user != null).map(p -> p.user).collect(Collectors.toList());
        List newUsers = workspace.permissions.stream().filter(p -> p.user != null).map(p -> p.user).collect(Collectors.toList());
        return this.getListDifference(existingUsers, newUsers);
    }

    private List<String> getGroupDifference(@Nullable Workspace existingWorkspace, @Nullable Workspace workspace) {
        if (existingWorkspace == null || workspace == null) {
            return new ArrayList<String>();
        }
        List existingGroups = existingWorkspace.permissions.stream().filter(p -> p.group != null).map(p -> p.group).collect(Collectors.toList());
        List newGroups = workspace.permissions.stream().filter(p -> p.group != null).map(p -> p.group).collect(Collectors.toList());
        return this.getListDifference(existingGroups, newGroups);
    }

    private List<String> getPendingUserEmailDifference(@Nullable Workspace existingWorkspace, @Nullable Workspace workspace) {
        if (workspace == null) {
            return new ArrayList<String>();
        }
        List<String> newEmails = workspace.permissions.stream().filter(p -> p.pendingUserEmail != null).map(p -> p.pendingUserEmail).collect(Collectors.toList());
        if (existingWorkspace == null) {
            return newEmails;
        }
        List existingEmails = existingWorkspace.permissions.stream().filter(p -> p.pendingUserEmail != null).map(p -> p.pendingUserEmail).collect(Collectors.toList());
        return this.getListDifference(existingEmails, newEmails);
    }

    private <T> List<T> getListDifference(List<T> existingItems, List<T> newItems) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : newItems) {
            if (existingItems.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    private static List<BasePermissions.PermissionItem> squashPermissions(List<BasePermissions.PermissionItem> permissions) {
        ArrayList<BasePermissions.PermissionItem> result = new ArrayList<BasePermissions.PermissionItem>();
        if (permissions != null) {
            for (BasePermissions.PermissionItem item : permissions) {
                if (item == null) continue;
                BasePermissions.PermissionItem existing = WorkspacesService.getExistingPermissionItem(result, item);
                if (existing == null) {
                    BasePermissions.PermissionItem newItem = new BasePermissions.PermissionItem();
                    newItem.user = item.user;
                    newItem.group = item.group;
                    newItem.pendingUserEmail = item.pendingUserEmail;
                    newItem.invitationEmailStatus = item.invitationEmailStatus;
                    newItem.admin = item.admin;
                    newItem.write = item.write || newItem.admin;
                    newItem.read = item.read || newItem.write;
                    result.add(newItem);
                    continue;
                }
                existing.admin |= item.admin;
                existing.write = existing.write | (item.write || existing.admin);
                existing.read = existing.read | (item.read || existing.write);
            }
        }
        return result;
    }

    private static BasePermissions.PermissionItem getExistingPermissionItem(List<BasePermissions.PermissionItem> permissions, BasePermissions.PermissionItem item) {
        for (BasePermissions.PermissionItem permission : permissions) {
            if (!(StringUtils.isNotBlank((String)permission.user) && Objects.equals(item.user, permission.user) || StringUtils.isNotBlank((String)permission.group) && Objects.equals(item.group, permission.group)) && (!StringUtils.isNotBlank((String)item.pendingUserEmail) || !StringUtils.isNotBlank((String)permission.pendingUserEmail) || !Objects.equals(item.pendingUserEmail.toLowerCase(Locale.ROOT), permission.pendingUserEmail.toLowerCase(Locale.ROOT)))) continue;
            return permission;
        }
        return null;
    }

    private List<Workspace.WorkspaceObject> differenceObjects(@Nullable Workspace existingWorkspace, @Nullable Workspace workspace) {
        ArrayList<Workspace.WorkspaceObject> result = new ArrayList<Workspace.WorkspaceObject>();
        if (workspace == null || existingWorkspace == null) {
            return result;
        }
        for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
            if (existingWorkspace.workspaceObjects.contains(workspaceObject)) continue;
            result.add(workspaceObject);
        }
        return result;
    }

    private Workspace enrichWorkspace(AuthCtx authCtx, Workspace workspace, boolean enrichPermissions, boolean enrichObjects) throws IOException {
        if (workspace != null) {
            if (enrichPermissions) {
                workspace.currentUserPermissions = new BasePermissions.PermissionItem();
                try {
                    workspace.currentUserPermissions.admin = this.permissionsService.hasWorkspacePrivileges(authCtx, workspace, Privileges.WorkspaceLevelPrivilegeType.ADMIN);
                    workspace.currentUserPermissions.write = workspace.currentUserPermissions.admin || this.permissionsService.hasWorkspacePrivileges(authCtx, workspace, Privileges.WorkspaceLevelPrivilegeType.WRITE);
                    workspace.currentUserPermissions.read = workspace.currentUserPermissions.write || this.permissionsService.hasWorkspacePrivileges(authCtx, workspace, Privileges.WorkspaceLevelPrivilegeType.READ);
                }
                catch (DKUSecurityException e) {
                    logger.error((Object)"Unable to retrieve workspace permissions for current user", (Throwable)e);
                }
            }
            if (enrichObjects) {
                GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
                ListIterator<Workspace.WorkspaceObject> iterator = workspace.workspaceObjects.listIterator();
                while (iterator.hasNext()) {
                    Workspace.WorkspaceObject workspaceObject = iterator.next();
                    try {
                        this.enrichWorkspaceObject(authCtx, workspace.workspaceKey, workspaceObject, generalSettings);
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Unable to enrich workspace object %s. Ignoring it.", new Object[]{workspaceObject});
                        iterator.remove();
                    }
                }
            }
        }
        return workspace;
    }

    public void enrichWorkspaceObject(AuthCtx authCtx, String workspaceKey, Workspace.WorkspaceObject workspaceObject) throws Exception {
        this.enrichWorkspaceObject(authCtx, workspaceKey, workspaceObject, this.generalSettingsService.read());
    }

    public void enrichWorkspaceObject(AuthCtx authCtx, String workspaceKey, Workspace.WorkspaceObject workspaceObject, GeneralSettingsDAO.GeneralSettings generalSettings) throws Exception {
        if (workspaceObject.reference != null) {
            if (!Objects.equals(workspaceObject.reference.workspaceKey, workspaceKey)) {
                workspaceObject.reference = new TaggableObjectsService.TaggableObjectRef(workspaceObject.reference.projectKey, workspaceObject.reference.type, workspaceObject.reference.id, workspaceKey);
            }
            if (workspaceObject.reference.type == ITaggingService.TaggableType.DASHBOARD) {
                Dashboard dashboard = (Dashboard)this.dashboardsDAO.getMandatoryUnsafe(workspaceObject.reference.projectKey, workspaceObject.reference.id);
                if (dashboard == null) {
                    workspaceObject.defaultName = workspaceObject.reference.id;
                } else {
                    workspaceObject.defaultName = dashboard.getDisplayName();
                    workspaceObject.subType = dashboard.getSubtype();
                    workspaceObject.defaultThumbnailData = generalSettings.graphicsExportsEnabled ? this.getObjectThumbnail(dashboard.projectKey, "DASHBOARD", dashboard.id) : null;
                    workspaceObject.shortDesc = dashboard.shortDesc;
                    workspaceObject.description = dashboard.description;
                    if (dashboard.versionTag != null) {
                        workspaceObject.lastModifiedOn = dashboard.versionTag.getLastModifiedOn();
                        workspaceObject.lastModifiedBy = dashboard.versionTag.getLastAuthor();
                    }
                    if (!dashboard.pages.isEmpty()) {
                        workspaceObject.extraInfo = JSON.toJsonArray(dashboard.pages.get((int)0).grid.tiles);
                    }
                }
            } else if (workspaceObject.reference.type == ITaggingService.TaggableType.DATASET) {
                SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(workspaceObject.reference.projectKey, workspaceObject.reference.id);
                if (dataset == null) {
                    workspaceObject.defaultName = workspaceObject.reference.id;
                } else {
                    workspaceObject.defaultName = dataset.getDisplayName();
                    workspaceObject.subType = dataset.getSubtype();
                    workspaceObject.defaultThumbnailData = this.getObjectThumbnail(dataset.projectKey, "DATASET", dataset.name);
                    workspaceObject.shortDesc = dataset.shortDesc;
                    workspaceObject.description = dataset.description;
                    if (dataset.versionTag != null) {
                        workspaceObject.lastModifiedOn = dataset.versionTag.getLastModifiedOn();
                        workspaceObject.lastModifiedBy = dataset.versionTag.getLastAuthor();
                    }
                }
            } else if (workspaceObject.reference.type == ITaggingService.TaggableType.WEB_APP) {
                WebApp webapp = (WebApp)this.webAppsDAO.getMandatoryUnsafe(workspaceObject.reference.projectKey, workspaceObject.reference.id);
                if (webapp == null) {
                    workspaceObject.defaultName = workspaceObject.reference.id;
                } else {
                    workspaceObject.defaultName = webapp.getDisplayName();
                    workspaceObject.subType = webapp.getSubtype();
                    workspaceObject.defaultThumbnailData = this.getObjectThumbnail(webapp.projectKey, "WEB_APP", webapp.id);
                    workspaceObject.shortDesc = webapp.shortDesc;
                    workspaceObject.description = webapp.description;
                    if (webapp.versionTag != null) {
                        workspaceObject.lastModifiedOn = webapp.versionTag.getLastModifiedOn();
                        workspaceObject.lastModifiedBy = webapp.versionTag.getLastAuthor();
                    }
                }
            } else if (workspaceObject.reference.type == ITaggingService.TaggableType.ARTICLE) {
                Article article = (Article)this.articlesDAO.getMandatoryUnsafe(workspaceObject.reference.projectKey, workspaceObject.reference.id);
                if (article == null) {
                    workspaceObject.defaultName = workspaceObject.reference.id;
                } else {
                    workspaceObject.defaultName = article.getDisplayName();
                    workspaceObject.subType = article.getSubtype();
                    workspaceObject.defaultThumbnailData = this.getObjectThumbnail(article.projectKey, "ARTICLE", article.id);
                    workspaceObject.shortDesc = article.shortDesc;
                    workspaceObject.description = article.description;
                    if (article.versionTag != null) {
                        workspaceObject.lastModifiedOn = article.versionTag.getLastModifiedOn();
                        workspaceObject.lastModifiedBy = article.versionTag.getLastAuthor();
                    }
                }
            }
        } else if (workspaceObject.htmlLink != null) {
            workspaceObject.defaultName = workspaceObject.htmlLink.name;
            workspaceObject.shortDesc = workspaceObject.htmlLink.description;
        } else if (workspaceObject.appId != null) {
            AppsService.AppTemplatePageData app = this.appsService.getAppTemplatePageData_T(authCtx, workspaceObject.appId);
            workspaceObject.defaultName = app.label;
            workspaceObject.shortDesc = app.shortDesc;
            workspaceObject.lastModifiedOn = app.lastInstantiation;
        } else if (workspaceObject.story != null) {
            workspaceObject.defaultName = workspaceObject.story.title;
            workspaceObject.shortDesc = workspaceObject.story.description;
        } else {
            throw new UnsupportedOperationException("Object type cannot be determined");
        }
        String string = workspaceObject.displayName = workspaceObject.customName == null ? workspaceObject.defaultName : workspaceObject.customName;
        if (workspaceObject.thumbnailMode == null) {
            workspaceObject.thumbnailMode = Workspace.ThumbnailMode.DEFAULT;
        }
        switch (workspaceObject.thumbnailMode) {
            case UPLOAD: {
                workspaceObject.thumbnailData = workspaceObject.customThumbnailImage;
                break;
            }
            case DESCRIPTION: {
                workspaceObject.thumbnailData = workspaceObject.customThumbnailDescription;
                break;
            }
            default: {
                workspaceObject.thumbnailData = workspaceObject.defaultThumbnailData;
            }
        }
    }

    public void enrichWithInterest_NT(AuthCtx authCtx, Workspace workspace) throws SQLException {
        if (workspace == null) {
            return;
        }
        this.enrichWithInterest_NT(authCtx, workspace.workspaceKey, workspace.workspaceObjects);
    }

    public void enrichWithInterest_NT(AuthCtx authCtx, String workspaceKey, Collection<Workspace.WorkspaceObject> workspaceObjects) throws SQLException {
        if (workspaceObjects == null) {
            return;
        }
        for (Workspace.WorkspaceObject workspaceObject : workspaceObjects) {
            this.enrichWithInterest_NT(authCtx, workspaceKey, workspaceObject);
        }
    }

    public void enrichWithInterest_NT(AuthCtx authCtx, String workspaceKey, Workspace.WorkspaceObject workspaceObject) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (workspaceObject == null || workspaceObject.reference == null) {
            return;
        }
        InterestsInternalDB.Interest interest = this.interestsService.getObjectAndUserInterest_NT(authCtx, workspaceObject.reference.type, workspaceObject.reference.projectKey, workspaceObject.reference.id, workspaceKey);
        if (interest != null) {
            workspaceObject.starred = interest.starred;
        }
    }

    public void enrichDatastory(AuthCtx authCtx, Workspace.WorkspaceObject object) {
        TransactionContext.assertNoAttachedTransaction();
        if (object != null && object.story != null) {
            try {
                object.defaultThumbnailData = this.getDatastoryThumbnail(authCtx, object.story.id);
            }
            catch (Exception e) {
                object.defaultThumbnailData = null;
                logger.error((Object)"Error during retrieval of story thumbnail", (Throwable)e);
            }
        }
    }

    public String getDatastoryThumbnail(AuthCtx authCtx, String id) throws IOException {
        return "data:image/png;base64,\n" + BaseEncoding.base64().encode(this.dataStoryService.getThumbnail(authCtx, id));
    }

    public void updateWorkspaceObject(DSSAuthCtx authCtx, Workspace workspace, Workspace.WorkspaceObject newData) throws Exception {
        Workspace.WorkspaceObject workspaceObjectFound = WorkspacesService.findObjectWithId(workspace, newData.id);
        if (workspaceObjectFound == null) {
            throw new NotFoundException(String.format("Object with id: %s does not exist in the workspace", newData.id));
        }
        if (workspaceObjectFound.story != null && newData.story != null) {
            workspaceObjectFound.story.title = newData.story.title;
            workspaceObjectFound.story.description = newData.story.description;
        } else if (newData.htmlLink != null) {
            workspaceObjectFound.htmlLink.description = newData.htmlLink.description;
            workspaceObjectFound.htmlLink.url = newData.htmlLink.url;
        } else {
            workspaceObjectFound.customName = newData.customName;
        }
        workspaceObjectFound.thumbnailMode = newData.thumbnailMode;
        workspaceObjectFound.customThumbnailImage = newData.customThumbnailImage;
        workspaceObjectFound.customThumbnailDescription = newData.customThumbnailDescription;
        this.workspacesDAO.save(workspace);
    }

    private void convertWorkspacePendingUserEmailPermissionsIfMatchingUser(Workspace workspace) {
        if (workspace == null || workspace.permissions == null) {
            return;
        }
        try {
            List pendingEmailPermissions = workspace.permissions.stream().filter(permission -> permission != null && StringUtils.isNotBlank((String)permission.pendingUserEmail)).collect(Collectors.toList());
            if (!pendingEmailPermissions.isEmpty()) {
                GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                    return;
                }
                Multimap<String, String> loginsByEmails = UsersService.buildLoginsByEmailMap(this.usersService.listUsersUnsafe());
                for (BasePermissions.PermissionItem permission2 : pendingEmailPermissions) {
                    if (permission2.pendingUserEmail == null) continue;
                    Collection matchingUserLogins = loginsByEmails.get((Object)permission2.pendingUserEmail.toLowerCase(Locale.ROOT));
                    if (matchingUserLogins.size() == 1) {
                        String login = (String)matchingUserLogins.iterator().next();
                        this.convertPendingPermissionItem(permission2, login);
                        continue;
                    }
                    if (matchingUserLogins.size() <= 1) continue;
                    logger.warnV("Multiple users (%s) found for email %s, not converting permission %s in workspace %s.", new Object[]{String.join((CharSequence)", ", matchingUserLogins), permission2.pendingUserEmail, JSON.json((Object)permission2), workspace.workspaceKey});
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to convert pendingUserEmail permission for workspace " + workspace.workspaceKey), (Throwable)e);
        }
    }

    @VisibleForTesting
    void resolveInvitationEmailStatuses(Workspace workspace) {
        try {
            Workspace existingWorkspace = this.workspacesDAO.getOrNullUnsafe(workspace.workspaceKey);
            if (existingWorkspace == null) {
                return;
            }
            HashMap statusesByEmail = new HashMap();
            existingWorkspace.permissions.stream().filter(permission -> permission != null && permission.pendingUserEmail != null && permission.invitationEmailStatus != null).forEach(permission -> statusesByEmail.put(permission.pendingUserEmail.toLowerCase(Locale.ROOT), permission.invitationEmailStatus));
            for (BasePermissions.PermissionItem permission2 : workspace.permissions) {
                if (permission2 == null || permission2.pendingUserEmail == null || AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)permission2.invitationEmailStatus) || AbstractInviteEmailSendService.InvitationEmailStatus.FAILED.equals((Object)permission2.invitationEmailStatus)) continue;
                String normalizedEmail = permission2.pendingUserEmail.toLowerCase(Locale.ROOT);
                permission2.invitationEmailStatus = statusesByEmail.getOrDefault(normalizedEmail, permission2.invitationEmailStatus);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to check for existing email permission statuses in workspace " + workspace.workspaceKey));
        }
    }

    private void convertPendingPermissionItem(BasePermissions.PermissionItem item, String user) {
        assert (item.pendingUserEmail != null);
        item.user = user;
        item.pendingUserEmail = null;
        item.invitationEmailStatus = null;
    }

    private String getObjectThumbnail(String projectKey, String type, String id) throws IOException {
        try (InputStream thumbnailStream = this.imageService.getImage(projectKey, type, id, null, new MutableLong(), null, null, null);){
            if (thumbnailStream == null) {
                String string = null;
                return string;
            }
            String string = "data:image/png;base64,\n" + BaseEncoding.base64().encode(ByteStreams.toByteArray((InputStream)thumbnailStream));
            return string;
        }
    }

    private DSSEvent buildShareEvent(TaggableObjectsService.TaggableObjectRef tor, AuthCtx authCtx, String workspaceKey, JsonObject details) {
        String projectKey = tor.getLoc().getProjectKey();
        return new TaggableObjectChangedEvent(tor.type, projectKey, tor.id, authCtx, this.shareAction(tor.type), null, workspaceKey).withDetails(details);
    }

    private DSSEvent buildWorkspaceObjectAddedEvent(TaggableObjectsService.TaggableObjectRef tor, AuthCtx authCtx, String workspaceKey) {
        return this.buildWorkspaceObjectChangeEvent(tor, authCtx, workspaceKey, WorkspaceObjectChangedEvent.ActionCategory.ADDED);
    }

    private DSSEvent buildWorkspaceObjectRemovedEvent(TaggableObjectsService.TaggableObjectRef tor, AuthCtx authCtx, String workspaceKey) {
        return this.buildWorkspaceObjectChangeEvent(tor, authCtx, workspaceKey, WorkspaceObjectChangedEvent.ActionCategory.REMOVED);
    }

    private DSSEvent buildWorkspaceObjectChangeEvent(TaggableObjectsService.TaggableObjectRef tor, AuthCtx authCtx, String workspaceKey, WorkspaceObjectChangedEvent.ActionCategory action) {
        String user = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceObjectChangedEvent(workspaceKey, tor.projectKey, tor.type, tor.id, action, user);
    }

    private DSSEvent buildWorkspaceLinkEvent(AuthCtx authCtx, String workspaceKey, Workspace.HtmlLink link, WorkspaceObjectChangedEvent.ActionCategory action) {
        String user = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceLinkChangedEvent(workspaceKey, link.name, link.url, action, user);
    }

    private DSSEvent buildCreateEvent(AuthCtx authCtx, Workspace workspace) {
        String user = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceCreatedEvent(workspace.workspaceKey, workspace.displayName, user);
    }

    private DSSEvent buildUpdateEvent(AuthCtx authCtx, Workspace workspace) {
        String user = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceUpdatedEvent(workspace.workspaceKey, workspace.displayName, user);
    }

    private DSSEvent buildDeleteEvent(String workspaceKey) {
        return new WorkspaceDeletedEvent(workspaceKey);
    }

    private DSSEvent buildDatastoryObjectCreatedEvent(AuthCtx authCtx, String workspaceKey, Workspace.Story story) {
        return this.buildDatastoryObjectEvent(authCtx, workspaceKey, story, WorkspaceObjectChangedEvent.ActionCategory.ADDED);
    }

    private DSSEvent buildDatastoryObjectRemovedEvent(AuthCtx authCtx, String workspaceKey, Workspace.Story story) {
        return this.buildDatastoryObjectEvent(authCtx, workspaceKey, story, WorkspaceObjectChangedEvent.ActionCategory.REMOVED);
    }

    private DSSEvent buildDatastoryObjectEvent(AuthCtx authCtx, String workspaceKey, Workspace.Story story, WorkspaceObjectChangedEvent.ActionCategory action) {
        String user = authCtx != null ? authCtx.getIdentifier() : null;
        return new WorkspaceDatastoryChangedEvent(workspaceKey, story.title, story.id, action, user);
    }

    private TaggableObjectChangedEvent.ActionType shareAction(ITaggingService.TaggableType type) {
        switch (type) {
            case DASHBOARD: {
                return TaggableObjectChangedEvent.ActionType.DASHBOARD_SHARED_TO_WORKSPACE;
            }
            case INSIGHT: {
                return TaggableObjectChangedEvent.ActionType.INSIGHT_SHARED_TO_WORKSPACE;
            }
            case WEB_APP: {
                return TaggableObjectChangedEvent.ActionType.WEB_APP_SHARED_TO_WORKSPACE;
            }
            case ARTICLE: {
                return TaggableObjectChangedEvent.ActionType.ARTICLE_SHARED_TO_WORKSPACE;
            }
            case DATASET: {
                return TaggableObjectChangedEvent.ActionType.DATASET_SHARED_TO_WORKSPACE;
            }
        }
        return TaggableObjectChangedEvent.ActionType.UNKNOWN;
    }

    private String generateWorkspaceObjectId(Workspace.WorkspaceObject workspaceObject) {
        String existingId = workspaceObject != null && workspaceObject.story != null ? workspaceObject.story.id : null;
        return StringUtils.isBlank(existingId) ? SecretKeyGenerator.generate((int)8) : existingId;
    }

    private static boolean isAdmin(String user, Workspace workspace) {
        for (BasePermissions.PermissionItem permission : workspace.permissions) {
            if (!user.equals(permission.user)) continue;
            return permission.admin;
        }
        return false;
    }

    private static JsonObject workspaceDetails(Workspace workspace) {
        JsonObject details = new JsonObject();
        details.addProperty("workspaceDisplayName", workspace.displayName);
        return details;
    }

    private static boolean isObjectAuthorized(TaggableObjectsService.TaggableObjectRef objectRef, SerializedProject.ProjectDashboardAuthorizations dashboardAuthorizations, SerializedProject.ReaderAuthorization.Mode mode) {
        return dashboardAuthorizations.allAuthorized || dashboardAuthorizations.authorizations.stream().anyMatch(authorization -> authorization.objectRef != null && authorization.objectRef.objectId.equals(objectRef.id) && authorization.objectRef.objectType.equals((Object)objectRef.type) && authorization.can(mode));
    }

    private static Optional<SerializedProject.ReaderAuthorization> getDashboardAuthorization(TaggableObjectsService.TaggableObjectRef objectRef, SerializedProject.ProjectDashboardAuthorizations dashboardAuthorizations) {
        return dashboardAuthorizations.authorizations.stream().filter(authorization -> authorization.objectRef != null && authorization.objectRef.objectId.equals(objectRef.id) && authorization.objectRef.objectType.equals((Object)objectRef.type)).findAny();
    }

    private static Workspace.WorkspaceObject findObjectWithId(Workspace workspace, String objectId, Function<Workspace.WorkspaceObject, Boolean> validator) {
        for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
            if (!Objects.equals(workspaceObject.id, objectId) || !validator.apply(workspaceObject).booleanValue()) continue;
            return workspaceObject;
        }
        return null;
    }

    public static boolean needsShareToWorkspaceRights(Workspace.WorkspaceObject object) {
        return object.reference != null || StringUtils.isNotBlank((String)object.appId);
    }

    public static Workspace.WorkspaceObject findObjectWithId(Workspace workspace, String objectId) {
        return WorkspacesService.findObjectWithId(workspace, objectId, wo -> true);
    }

    public static Workspace.WorkspaceObject findDatasetWithId(Workspace workspace, String objectId) {
        Function<Workspace.WorkspaceObject, Boolean> isDataset = wo -> wo.reference != null && wo.reference.type == ITaggingService.TaggableType.DATASET;
        return WorkspacesService.findObjectWithId(workspace, objectId, isDataset);
    }
}

