/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.booleans;

import com.google.refine.expr.functions.booleans.Not;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;

public class And
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        for (Object o : args) {
            if (Not.objectToBoolean(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.And.DOCUMENTATION", "Evaluates logical AND (conjunction) on several statements. All conditions need to be fulfilled for the function to return true. Is equivalent to <code>a &amp;&amp; b</code>.").withParams("boolean a, boolean b").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.BOOLEAN", "Boolean functions").withExample(Example.with("1==1", "3<4").returns("true"));
    }
}

