/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SubscriptionsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ISubscriptionsService subscriptionsService;

    @AuditedCall(value={"msgType", "artifact-subscribe", "artifactId", "${artifactId}", "subscriptionLevel", "${subscriptionLevel}"})
    @RequestMapping(value={"/api/subscriptions/subscribe"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SUBSCRIPTION_SUBSCRIBE)
    @ResponseBody
    public Subscription subscribe(HttpServletRequest req, @RequestParam String artifactId, @RequestParam Subscription.SubscriptionLevel subscriptionLevel) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.subscriptionsService.subscribe(authCtx, artifactId, subscriptionLevel);
    }

    @AuditedCall(value={"msgType", "artifact-unsubscribe", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/subscriptions/unsubscribe"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SUBSCRIPTION_UNSUBSCRIBE)
    @ResponseBody
    public Subscription unsubscribe(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.subscriptionsService.unsubscribe(authCtx, artifactId);
    }
}

