/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.governance.IGovernanceQueueCoordinatorService;
import com.dataiku.gh.core.services.governance.IGovernanceQueueExecutorService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.storage.sql.search.governance.IGovernanceArtifactSearchDAO;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceQueueCoordinatorService
implements IGovernanceQueueCoordinatorService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.governance-queue-coordinator-service");
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IGovernanceArtifactSearchDAO governanceArtifactSearchDAO;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IGovernanceQueueExecutorService governanceQueueExecutorService;

    @Override
    @GHReadonlyTransaction
    public void triggerInstanceGovernanceRun(AuthCtx authCtx) throws UnauthorizedException, IOException {
        this.permissionsService.checkMayManageGovern(authCtx);
        List<String> artifactIds = this.computeInstanceElementsToRunGovernanceOn();
        logger.info((Object)String.format("Instance governance run: adding %s artifacts to governance queue", artifactIds.size()));
        this.governanceQueueExecutorService.addToGovernanceQueue(artifactIds);
    }

    private List<String> computeInstanceElementsToRunGovernanceOn() throws IOException {
        return this.governanceArtifactSearchDAO.findAllInstanceElementsToRunAutoGovernanceOn().stream().toList();
    }

    @Override
    @GHReadonlyTransaction
    public void triggerArtifactGovernanceRun(AuthCtx authCtx, String artifactId) throws DKUSecurityException, IOException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
        List<String> artifactIds = this.computeElementsToRunGovernanceOnFromArtifact(enrichedArtifact);
        logger.info((Object)String.format("Artifact (ID: %s) governance run: adding %s artifacts to governance queue", artifactId, artifactIds.size()));
        this.governanceQueueExecutorService.addToGovernanceQueue(artifactIds);
    }

    private List<String> computeElementsToRunGovernanceOnFromArtifact(EnrichedArtifact enrichedArtifact) throws IOException {
        Set<String> elementsToRunGovernanceOn = this.governanceArtifactSearchDAO.findElementsFromArtifactToRunAutoGovernanceOn(enrichedArtifact.artifact);
        return elementsToRunGovernanceOn.stream().toList();
    }
}

