/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles;

import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.ReferenceFieldDefinition;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.models.roles.assignments.criteria.Criterion;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUserBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.RoleAssignmentsComputationUtils;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.extractor.UsersContainerExtractor;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.visitors.HierarchicalFieldDefinitionVisitor;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersAndAPIKeysBlueprintRoleAssignmentsComputationService
implements IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService {
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;

    @Override
    @GHMandatoryTransaction
    public List<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> computeUserLoginsAndAPIKeyIdsForRolesAtArtifactExistingLevel(EnrichedArtifact enrichedArtifact) throws IOException {
        return this.computeUserLoginsAndAPIKeyIdsForRolesAtArtifactExistingLevel(enrichedArtifact, RolesAndPermissionsAudit.buildAtArtifactExistingLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedArtifact));
    }

    @Override
    @GHMandatoryTransaction
    public List<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> computeUserLoginsAndAPIKeyIdsForRolesAtArtifactExistingLevel(EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Map<String, UsersContainersExtraction> usersDefinitionsForRoles = this.computeUsersDefinitionsForRolesAtArtifactExistingLevel(enrichedArtifact, rolesAndPermissionsAudit.rolesAssignmentsAudit);
        return this.buildUserLoginsAndAPIKeyIdsForRole(usersDefinitionsForRoles, rolesAndPermissionsAudit);
    }

    private List<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> buildUserLoginsAndAPIKeyIdsForRole(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Set allGlobalScopePublicAPIKeyIds;
        List<UsersDAO.User> allUsers;
        try (Transaction t = this.transactionService.beginRead();){
            allUsers = this.usersDAO.listUsers();
            allGlobalScopePublicAPIKeyIds = this.publicAPIKeysService.listGlobalAPIKeys().stream().map(gapi -> gapi.id).collect(Collectors.toSet());
        }
        Set allUserLogins = allUsers.stream().map(u -> u.login).collect(Collectors.toSet());
        Map allUserLoginsPerGroup = allUsers.stream().flatMap(u -> u.groups.stream().map(gN -> ImmutablePair.of((Object)u.login, (Object)gN))).collect(Collectors.groupingBy(ImmutablePair::getRight, Collectors.mapping(ImmutablePair::getLeft, Collectors.toSet())));
        ArrayList<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> userLoginsAndAPIKeyIdsForRoles = new ArrayList<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>();
        for (Map.Entry<String, UsersContainersExtraction> entry : usersDefinitionsForRoles.entrySet()) {
            String roleId = entry.getKey();
            UsersContainersExtraction usersContainersExtraction = entry.getValue();
            Role role = (Role)this.roleDAO.getMandatory(roleId);
            HashSet userLogins = Sets.newHashSet((Iterable)Sets.intersection(allUserLogins, usersContainersExtraction.logins));
            usersContainersExtraction.groupNames.stream().map(allUserLoginsPerGroup::get).filter(Objects::nonNull).forEach(userLogins::addAll);
            HashSet apiKeyIds = Sets.newHashSet((Iterable)Sets.intersection(allGlobalScopePublicAPIKeyIds, usersContainersExtraction.globalAPIKeyIds));
            IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole userLoginsAndAPIKeyIdsForRole = IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole.build(role, userLogins, apiKeyIds);
            userLoginsAndAPIKeyIdsForRole.userLogins.forEach(userLogin -> rolesAndPermissionsAudit.byUserAudit((String)userLogin).rolesAssignmentsAudit.addRoleAssignmentAudit(role.id).declareRoleAssigned());
            if (userLoginsAndAPIKeyIdsForRole.isEmpty()) continue;
            userLoginsAndAPIKeyIdsForRoles.add(userLoginsAndAPIKeyIdsForRole);
        }
        return userLoginsAndAPIKeyIdsForRoles;
    }

    private Map<String, UsersContainersExtraction> computeUsersDefinitionsForRolesAtBlueprintLevel(EnrichedBlueprint enrichedBlueprint, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit, Set<String> visitedBlueprintIds) throws IOException {
        if (enrichedBlueprint.blueprintRoleAssignments == null) {
            return Maps.newHashMap();
        }
        HashMap usersDefinitionsForRoles = Maps.newHashMap();
        for (EnrichedBlueprint enrichedBlueprint2 : this.getInheritEnrichedBlueprints(enrichedBlueprint.blueprintRoleAssignments, rolesAssignmentsAudit.blueprintsInheritanceLookupAudit)) {
            if (visitedBlueprintIds.contains(enrichedBlueprint2.blueprint.id)) continue;
            visitedBlueprintIds.add(enrichedBlueprint2.blueprint.id);
            RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsBlueprintInheritanceAudit = rolesAssignmentsAudit.addBlueprintInheritance(enrichedBlueprint2.blueprint.id);
            this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, this.computeUsersDefinitionsForRolesAtBlueprintLevel(enrichedBlueprint2, rolesAssignmentsBlueprintInheritanceAudit, visitedBlueprintIds));
        }
        for (Map.Entry entry : enrichedBlueprint.blueprintRoleAssignments.roleAssignmentsRules.entrySet()) {
            String roleId = (String)entry.getKey();
            RolesAndPermissionsAudit.RoleAssignmentAudit roleAssignmentAudit = rolesAssignmentsAudit.addRoleAssignmentAudit(roleId);
            for (RoleAssignmentsRule rar : (List)entry.getValue()) {
                RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit;
                BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate;
                if (RoleAssignmentsComputationUtils.doRuleCriteriaComply(rar, criterionPredicate = RoleAssignmentsComputationUtils::doCriterionComplyAtBlueprintLevel, roleAssignmentRuleAudit = roleAssignmentAudit.addRoleAssignmentRuleAudit())) {
                    roleAssignmentRuleAudit.declareValid();
                    UsersContainersExtraction usersContainersExtraction = this.getAssignedUsersContainersExtraction(rar, null);
                    this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, roleId, usersContainersExtraction);
                    continue;
                }
                roleAssignmentRuleAudit.declareNotValid();
            }
        }
        return usersDefinitionsForRoles;
    }

    private Map<String, UsersContainersExtraction> computeUsersDefinitionsForRolesAtArtifactExistingLevel(EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        return this.computeUsersDefinitionsForRolesAtArtifactExistingLevel(enrichedArtifact, rolesAssignmentsAudit, Sets.newHashSet(), Sets.newHashSet((Object[])new String[]{enrichedArtifact.artifact.id}));
    }

    private Map<String, UsersContainersExtraction> computeUsersDefinitionsForRolesAtArtifactExistingLevel(EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit, Set<String> visitedBlueprintIds, Set<String> visitedArtifactIds) throws IOException {
        HashMap usersDefinitionsForRoles = Maps.newHashMap();
        this.computeUsersDefinitionsForRolesAtArtifactExistingLevelUsingBlueprintRAR(usersDefinitionsForRoles, enrichedArtifact, rolesAssignmentsAudit, visitedBlueprintIds, visitedArtifactIds);
        this.computeUsersDefinitionsForRolesAtArtifactExistingLevelUsingArtifactRAR(usersDefinitionsForRoles, enrichedArtifact, rolesAssignmentsAudit);
        return usersDefinitionsForRoles;
    }

    private void computeUsersDefinitionsForRolesAtArtifactExistingLevelUsingBlueprintRAR(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit, Set<String> visitedBlueprintIds, Set<String> visitedArtifactIds) throws IOException {
        if (enrichedArtifact.blueprintRoleAssignments == null) {
            return;
        }
        List<EnrichedBlueprint> inheritEnrichedBlueprints = this.getInheritEnrichedBlueprints(enrichedArtifact.blueprintRoleAssignments, rolesAssignmentsAudit.blueprintsInheritanceLookupAudit);
        for (EnrichedBlueprint inheritEnrichedBlueprint : inheritEnrichedBlueprints) {
            if (visitedBlueprintIds.contains(inheritEnrichedBlueprint.blueprint.id)) continue;
            visitedBlueprintIds.add(inheritEnrichedBlueprint.blueprint.id);
            RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsBlueprintInheritanceAudit = rolesAssignmentsAudit.addBlueprintInheritance(inheritEnrichedBlueprint.blueprint.id);
            this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, this.computeUsersDefinitionsForRolesAtBlueprintLevel(inheritEnrichedBlueprint, rolesAssignmentsBlueprintInheritanceAudit, visitedBlueprintIds));
        }
        List<EnrichedArtifact> inheritEnrichedArtifacts = this.getInheritEnrichedArtifacts(enrichedArtifact, rolesAssignmentsAudit.artifactsInheritanceLookupAudit);
        for (EnrichedArtifact inheritEnrichedArtifact : inheritEnrichedArtifacts) {
            if (visitedArtifactIds.contains(inheritEnrichedArtifact.artifact.id)) continue;
            visitedArtifactIds.add(inheritEnrichedArtifact.artifact.id);
            RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsArtifactInheritanceAudit = rolesAssignmentsAudit.addArtifactInheritance(inheritEnrichedArtifact.artifact.id);
            this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, this.computeUsersDefinitionsForRolesAtArtifactExistingLevel(inheritEnrichedArtifact, rolesAssignmentsArtifactInheritanceAudit, visitedBlueprintIds, visitedArtifactIds));
        }
        this.evaluateRoleAssignmentsRulesAndFillUsersExtraction(usersDefinitionsForRoles, enrichedArtifact, enrichedArtifact.blueprintRoleAssignments.roleAssignmentsRules, rolesAssignmentsAudit);
    }

    private void computeUsersDefinitionsForRolesAtArtifactExistingLevelUsingArtifactRAR(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        if (enrichedArtifact.artifactRoleAssignments == null) {
            return;
        }
        this.evaluateRoleAssignmentsRulesAndFillUsersExtraction(usersDefinitionsForRoles, enrichedArtifact, enrichedArtifact.artifactRoleAssignments.roleAssignmentsRules, rolesAssignmentsAudit);
    }

    private void evaluateRoleAssignmentsRulesAndFillUsersExtraction(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, EnrichedArtifact enrichedArtifact, Map<String, List<RoleAssignmentsRule>> rules, RolesAndPermissionsAudit.RolesAssignmentsAudit rolesAssignmentsAudit) throws IOException {
        for (Map.Entry<String, List<RoleAssignmentsRule>> entry : rules.entrySet()) {
            String roleId = entry.getKey();
            RolesAndPermissionsAudit.RoleAssignmentAudit roleAssignmentAudit = rolesAssignmentsAudit.addRoleAssignmentAudit(roleId);
            for (RoleAssignmentsRule rar : entry.getValue()) {
                RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit;
                BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate;
                if (RoleAssignmentsComputationUtils.doRuleCriteriaComply(rar, criterionPredicate = (criterion, audit) -> RoleAssignmentsComputationUtils.doCriterionComplyAtExistingArtifactLevel(criterion, enrichedArtifact, audit), roleAssignmentRuleAudit = roleAssignmentAudit.addRoleAssignmentRuleAudit())) {
                    roleAssignmentRuleAudit.declareValid();
                    UsersContainersExtraction usersContainersExtraction = this.getAssignedUsersContainersExtraction(rar, enrichedArtifact);
                    this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, roleId, usersContainersExtraction);
                    continue;
                }
                roleAssignmentRuleAudit.declareNotValid();
            }
        }
    }

    private List<EnrichedBlueprint> getInheritEnrichedBlueprints(BlueprintRoleAssignments blueprintRoleAssignments, RolesAndPermissionsAudit.BlueprintsInheritanceLookupAudit blueprintsInheritanceLookupAudit) throws IOException {
        ArrayList<EnrichedBlueprint> enrichedBlueprints = new ArrayList<EnrichedBlueprint>();
        for (String inheritBlueprintId : blueprintRoleAssignments.inheritBlueprintIds) {
            RolesAndPermissionsAudit.BlueprintInheritanceLookupAudit blueprintInheritanceLookupAudit = blueprintsInheritanceLookupAudit.addBlueprintInheritanceLookupAudit(inheritBlueprintId);
            if (StringUtils.isBlank((CharSequence)inheritBlueprintId)) continue;
            EnrichedBlueprint inheritEnrichedBlueprint = this.blueprintsDataService.getBlueprintOrNull(inheritBlueprintId);
            boolean bl = blueprintInheritanceLookupAudit.inheritanceValidAndFound = inheritEnrichedBlueprint != null;
            if (inheritEnrichedBlueprint == null) continue;
            enrichedBlueprints.add(inheritEnrichedBlueprint);
        }
        return enrichedBlueprints;
    }

    private List<EnrichedArtifact> getInheritEnrichedArtifacts(EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.ArtifactsInheritanceLookupAudit artifactsInheritanceLookupAudit) throws IOException {
        ArrayList<EnrichedArtifact> enrichedArtifacts = new ArrayList<EnrichedArtifact>();
        Set<String> inheritArtifactIds = RoleAssignmentsComputationUtils.getInheritArtifactIds(enrichedArtifact, artifactsInheritanceLookupAudit);
        for (String inheritArtifactId : inheritArtifactIds) {
            RolesAndPermissionsAudit.ArtifactInheritanceLookupAudit artifactInheritanceLookupFieldAudit = artifactsInheritanceLookupAudit.addArtifactInheritanceAudit(inheritArtifactId);
            EnrichedArtifact inheritEnrichedArtifact = this.artifactsDataService.getArtifactOrNull(inheritArtifactId);
            boolean bl = artifactInheritanceLookupFieldAudit.inheritanceValidAndFound = inheritEnrichedArtifact != null;
            if (inheritEnrichedArtifact == null) continue;
            enrichedArtifacts.add(inheritEnrichedArtifact);
        }
        return enrichedArtifacts;
    }

    private UsersContainersExtraction getAssignedUsersContainersExtraction(RoleAssignmentsRule roleAssignmentsRule, @Nullable EnrichedArtifact enrichedArtifact) throws IOException {
        final UsersContainersExtraction extraction = roleAssignmentsRule.userContainers.stream().collect(new UsersContainerExtractor());
        if (enrichedArtifact == null) {
            return extraction;
        }
        try {
            for (String fieldId : roleAssignmentsRule.fieldIds) {
                FieldDefinition fieldDefinition = enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
                final Object fieldValue = enrichedArtifact.artifact.fields.get(fieldId);
                if (fieldDefinition == null || fieldValue == null) continue;
                class UserGroupKeysCollector
                extends HierarchicalFieldDefinitionVisitor {
                    UserGroupKeysCollector() {
                    }

                    @Override
                    public void visit(ReferenceFieldDefinition fieldDefinition, String fieldId) {
                        super.visit(fieldDefinition, fieldId);
                        new IFieldAndListValueVisitor(){

                            @Override
                            public void visit(String stringFieldValue) {
                                EnrichedArtifact enrichedArtifact;
                                try {
                                    enrichedArtifact = UsersAndAPIKeysBlueprintRoleAssignmentsComputationService.this.artifactsDataService.getArtifact(stringFieldValue);
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                                if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.USER.blueprintId) && StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.userLogin)) {
                                    extraction.addLogin(enrichedArtifact.enrichedArtifactDetails.userLogin);
                                } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GROUP.blueprintId) && StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.groupName)) {
                                    extraction.addGroupName(enrichedArtifact.enrichedArtifactDetails.groupName);
                                } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GLOBAL_API_KEY.blueprintId) && StringUtils.isNotBlank((CharSequence)enrichedArtifact.enrichedArtifactDetails.globalAPIKeyId)) {
                                    extraction.addGlobalApiKey(enrichedArtifact.enrichedArtifactDetails.globalAPIKeyId);
                                }
                            }
                        }.visit(fieldValue);
                    }
                }
                UserGroupKeysCollector userGroupKeysCollector = new UserGroupKeysCollector();
                fieldDefinition.accept(userGroupKeysCollector, fieldId);
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        return extraction;
    }

    private void mergeUsersDefinitionsForRoles(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, Map<String, UsersContainersExtraction> additionalUsersDefinitionsForRoles) {
        if (MapUtils.isNotEmpty(additionalUsersDefinitionsForRoles)) {
            for (Map.Entry<String, UsersContainersExtraction> entry : additionalUsersDefinitionsForRoles.entrySet()) {
                this.mergeUsersDefinitionsForRoles(usersDefinitionsForRoles, entry.getKey(), entry.getValue());
            }
        }
    }

    private void mergeUsersDefinitionsForRoles(Map<String, UsersContainersExtraction> usersDefinitionsForRoles, String additionalRoleId, UsersContainersExtraction additionalUsersContainersExtraction) {
        if (additionalUsersContainersExtraction.isEmpty()) {
            return;
        }
        Optional<UsersContainersExtraction> newUsersContainersExtract = usersDefinitionsForRoles.entrySet().stream().filter(e -> StringUtils.equals((CharSequence)((CharSequence)e.getKey()), (CharSequence)additionalRoleId)).map(Map.Entry::getValue).findFirst();
        if (newUsersContainersExtract.isPresent()) {
            newUsersContainersExtract.get().addAll(additionalUsersContainersExtraction);
        } else {
            usersDefinitionsForRoles.put(additionalRoleId, additionalUsersContainersExtraction);
        }
    }
}

