/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.migration_paths;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.storage.migration_paths.IBlueprintVersionMigrationPathDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.migration_paths.BlueprintVersionMigrationPathRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionMigrationPaths;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionMigrationPathsHistory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;

public class BlueprintVersionMigrationPathDAO
extends AbstractItemBasedDAO<String, BlueprintVersionMigrationPath, BlueprintVersionMigrationPath>
implements IBlueprintVersionMigrationPathDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.migrationPaths");
    @Autowired
    private BlueprintVersionMigrationPathRowMapper blueprintVersionMigrationPathRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION_MIGRATION_PATH;
    }

    @Override
    protected RowMapper<BlueprintVersionMigrationPath> getRowMapper() {
        return this.blueprintVersionMigrationPathRowMapper;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationJson;
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory.blueprintVersionMigrationJson;
    }

    @Override
    protected Predicate getIdCondition(String id) {
        return QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id);
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprintVersionSource(BlueprintVersionId blueprintVersionIdSource) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildBaseSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintVersionIdSource.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdFrom.eq((Object)blueprintVersionIdSource.versionId))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildBaseSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdFrom.eq((Object)blueprintVersionId.versionId)).or((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdTo.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdTo.eq((Object)blueprintVersionId.versionId)))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprint(String blueprintId) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildBaseSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintId).or((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdTo.eq((Object)blueprintId))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    protected String getId(BlueprintVersionMigrationPath item) {
        return item.id;
    }
}

