/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.uploaded_files;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.uploaded_files.UploadedFile;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QUploadedFiles;
import com.dataiku.gh.core.storage.sql.model.QUploadedFilesHistory;
import com.dataiku.gh.core.storage.sql.uploaded_files.UploadedFileDescRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.uploaded_files.IUploadedFileDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.stereotype.Repository;

@Repository
public class UploadedFileDAO
extends AbstractPostgreSQLClient
implements IUploadedFileDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.uploaded_files");
    @Autowired
    private UploadedFileDescRowMapper uploadedFileDescRowMapper;
    @Autowired
    protected IHistoryDataService historyDataService;

    @Override
    public String newId() throws IOException {
        try {
            SQLQuery sqlQuery = this.sqlQueryFactory.select((Expression)SQLExpressions.nextval((String)"uploaded_files_seq"));
            long seq = this.querydslJdbcTemplate.queryForObject(sqlQuery, Long.class);
            return Long.toString(seq);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public boolean exists(String id) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
            return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public UploadedFileDesc getUploadedFileDesc(String id) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QUploadedFiles.uploadedFiles.uploadedFileJson).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
            return this.querydslJdbcTemplate.queryForObject(query, this.uploadedFileDescRowMapper);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new NotFoundException("Uploaded file does not exist: " + id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public Stream<UploadedFileDesc> listUploadedFileDescStream(List<String> ids) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QUploadedFiles.uploadedFiles.uploadedFileJson).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.in(ids));
            return this.querydslJdbcTemplate.queryForStream(query, this.uploadedFileDescRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public UploadedFile getUploadedFile(String id) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QUploadedFiles.uploadedFiles.uploadedFileJson, QUploadedFiles.uploadedFiles.uploadedFileData}).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
            return (UploadedFile)this.querydslJdbcTemplate.queryForObject(query, (rs, rowNumber) -> UploadedFile.build((UploadedFileDesc)JSON.parse((String)rs.getString(ColumnMetadata.getName(QUploadedFiles.uploadedFiles.uploadedFileJson)), UploadedFileDesc.class), rs.getBinaryStream(ColumnMetadata.getName(QUploadedFiles.uploadedFiles.uploadedFileData))));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new NotFoundException("Uploaded file does not exist: " + id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public UploadedFileDesc uploadFile(UploadedFileDesc uploadedFileDesc, InputStream is, long size) throws IOException {
        try {
            SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QUploadedFiles.uploadedFiles).columns(new Path[]{QUploadedFiles.uploadedFiles.uploadedFileJson, QUploadedFiles.uploadedFiles.uploadedFileData})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(uploadedFileDesc), new SqlParameterValue(2004, (Object)new SqlLobValue(is, (int)size))});
            QueryBuilderUtils.withReturning(query, new Expression[]{QUploadedFiles.uploadedFiles.uploadedFileJson});
            UploadedFileDesc insertResult = this.querydslJdbcTemplate.queryForObject((AbstractSQLClause<?>)query, this.uploadedFileDescRowMapper);
            this.insertHistoryRevision(RevisionType.ADD, insertResult.id);
            return insertResult;
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteUploadedFile(String id) throws IOException {
        if (!this.exists(id)) {
            throw new DataStoreIOException("Cannot delete uploaded file: " + id);
        }
        try {
            boolean ret;
            this.insertHistoryRevision(RevisionType.DELETE, id);
            SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QUploadedFiles.uploadedFiles).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
            boolean bl = ret = this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query) == 1;
            if (!ret) {
                throw new DataStoreIOException("Cannot delete uploaded file: " + id);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void insertHistoryRevision(RevisionType revisionType, String id) throws IOException {
        HistoryRevision historyRevision = this.historyDataService.createRevision(revisionType, EntityType.UPLOADED_FILE);
        SQLQuery selectJson = (SQLQuery)((SQLQuery)SQLExpressions.select(QUploadedFiles.uploadedFiles.uploadedFileJson).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
        SQLQuery selectData = (SQLQuery)((SQLQuery)SQLExpressions.select(QUploadedFiles.uploadedFiles.uploadedFileData).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq((Object)id));
        SQLInsertClause insertHistory = (SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QUploadedFilesHistory.uploadedFilesHistory).set(QUploadedFilesHistory.uploadedFilesHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).set(QUploadedFilesHistory.uploadedFilesHistory.uploadedFileData, (Expression)selectData)).set(QUploadedFilesHistory.uploadedFilesHistory.uploadedFileJson, (Object)selectJson);
        this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertHistory);
    }

    @Override
    public void deleteOwnersFromUploadedFiles(String owner) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select((Expression)QUploadedFiles.uploadedFiles.uploadedFileId).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QueryBuilderUtils.jsonString(QUploadedFiles.uploadedFiles.uploadedFileJson, new String[]{"owner"}).eq((Object)owner));
            Stream<String> queryStream = this.querydslJdbcTemplate.queryForStream(query, (rs, num) -> rs.getString(ColumnMetadata.getName((Path)QUploadedFiles.uploadedFiles.uploadedFileId)));
            SQLUpdateClause update = this.sqlQueryFactory.update((RelationalPath)QUploadedFiles.uploadedFiles);
            SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QUploadedFilesHistory.uploadedFilesHistory);
            AtomicBoolean hasAtLeastOneMatch = new AtomicBoolean(false);
            queryStream.forEach(id -> {
                HistoryRevision historyRevision;
                hasAtLeastOneMatch.set(true);
                ((SQLUpdateClause)((SQLUpdateClause)update.set(Collections.singletonList(QUploadedFiles.uploadedFiles.uploadedFileJson), Collections.singletonList(Expressions.template(Object.class, (String)"{0} - 'owner'", (Object[])new Object[]{QUploadedFiles.uploadedFiles.uploadedFileJson})))).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq(id))).addBatch();
                SQLQuery getNewJson = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QUploadedFiles.uploadedFiles.uploadedFileJson).from((Expression)QUploadedFiles.uploadedFiles)).where((Predicate)QUploadedFiles.uploadedFiles.uploadedFileId.eq(id));
                try {
                    historyRevision = this.historyDataService.createRevision(RevisionType.UPDATE, EntityType.UPLOADED_FILE);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QUploadedFilesHistory.uploadedFilesHistory.uploadedFileJson, (Object)getNewJson)).set(QUploadedFilesHistory.uploadedFilesHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).addBatch();
            });
            if (hasAtLeastOneMatch.get()) {
                this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)update);
                this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }
}

