/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GovernServerMain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.NestedServletException;

public class DKUDispatcherServlet
extends DispatcherServlet {
    private static final long serialVersionUID = 1L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dispatcher");

    public DKUDispatcherServlet() {
    }

    public DKUDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    protected void onRefresh(ApplicationContext context) {
        super.onRefresh(context);
        long now = System.currentTimeMillis();
        logger.info((Object)("DKUDispatcherServlet refreshed - startup_time=" + (now - GovernServerMain.BACKEND_STARTUP_TIME)));
    }

    public void noHandlerFound(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        logger.error((Object)("Not Found (404): '" + req.getRequestURI() + "'"));
        DIPInternalControllerBase.sendErrorExplicit((int)404, (String)"NotFound", (String)("Not Found: " + req.getRequestURI()), (HttpServletResponse)resp);
    }

    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            super.doDispatch(request, response);
        }
        catch (NestedServletException e) {
            logger.error((Object)"Caught ERROR", (Throwable)e);
            DIPInternalControllerBase.sendError((Throwable)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }
}

