/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.kernel.protocol.v5.magic;

import java.io.Serializable;
import org.apache.toree.magic.Magic;
import org.apache.toree.magic.MagicManager;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\n\u0014\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005W!)\u0011\u0007\u0001C\u0001e!9a\u0007\u0001b\u0001\n\u00139\u0004B\u0002!\u0001A\u0003%\u0001\b\u0003\u0005B\u0001\t\u0007I\u0011C\nC\u0011\u0019Y\u0005\u0001)A\u0005\u0007\")A\n\u0001C\u0005\u001b\")Q\f\u0001C\u0005=\"1\u0011\r\u0001C\t'\tDaA\u001b\u0001\u0005\u0012MY\u0007BB7\u0001\t#\u0019b\u000e\u0003\u0004z\u0001\u0011E1C\u001f\u0005\b\u007f\u0002!\tbEA\u0001\u0011!\t)\u0001\u0001C\t'\u0005\u001d\u0001\u0002CA\t\u0001\u0011E1#a\u0005\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\tYQ*Y4jGB\u000b'o]3s\u0015\t!R#A\u0003nC\u001eL7M\u0003\u0002\u0017/\u0005\u0011a/\u000e\u0006\u00031e\t\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u00035m\taa[3s]\u0016d'B\u0001\u000f\u001e\u0003\u0015!xN]3f\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\u00195\fw-[2NC:\fw-\u001a:\u0016\u0003-\u0002\"\u0001\f\u0018\u000e\u00035R!\u0001F\u000e\n\u0005=j#\u0001D'bO&\u001cW*\u00198bO\u0016\u0014\u0018!D7bO&\u001cW*\u00198bO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0003gU\u0002\"\u0001\u000e\u0001\u000e\u0003MAQ!K\u0002A\u0002-\n!\"\\1hS\u000e\u0014VmZ3y+\u0005A\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003!i\u0017\r^2iS:<'BA\u001f&\u0003\u0011)H/\u001b7\n\u0005}R$!\u0002*fO\u0016D\u0018aC7bO&\u001c'+Z4fq\u0002\n\u0001c[3s]\u0016dwJ\u00196fGRt\u0015-\\3\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004TiJLgnZ\u0001\u0012W\u0016\u0014h.\u001a7PE*,7\r\u001e(b[\u0016\u0004\u0013aC5t\u0019&tW-T1hS\u000e$\"AT)\u0011\u0005\u0011z\u0015B\u0001)&\u0005\u001d\u0011un\u001c7fC:DQA\u0015\u0005A\u0002M\u000b\u0001bY8eK2Kg.\u001a\t\u0003)ns!!V-\u0011\u0005Y+S\"A,\u000b\u0005a\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002[K\u00051\u0001K]3eK\u001aL!A\u0013/\u000b\u0005i+\u0013aC5t\u0007\u0016dG.T1hS\u000e$\"AT0\t\u000b\u0001L\u0001\u0019A*\u0002\u0011\r|G-\u001a\"m_\n\f!\u0002]1sg\u0016l\u0015mZ5d)\t\u0019\u0017\u000eE\u0002%I\u001aL!!Z\u0013\u0003\r=\u0003H/[8o!\u0011!smU*\n\u0005!,#A\u0002+va2,'\u0007C\u0003a\u0015\u0001\u00071+\u0001\tjgZ\u000bG.\u001b3MS:,W*Y4jGR\u0011a\n\u001c\u0005\u0006%.\u0001\raU\u0001\u0016a\u0006\u00148/Z(vi&sg/\u00197jI6\u000bw-[2t)\ty\u0007\u0010E\u0002qkNs!!]:\u000f\u0005Y\u0013\u0018\"\u0001\u0014\n\u0005Q,\u0013a\u00029bG.\fw-Z\u0005\u0003m^\u0014A\u0001T5ti*\u0011A/\n\u0005\u0006A2\u0001\raU\u0001\u000bgV\u00147\u000f^5ukR,GcA*|{\")A0\u0004a\u0001'\u0006IQ.Y4jG:\u000bW.\u001a\u0005\u0006}6\u0001\raU\u0001\u0005CJ<7/\u0001\btk\n\u001cH/\u001b;vi\u0016d\u0015N\\3\u0015\u0007M\u000b\u0019\u0001C\u0003S\u001d\u0001\u00071+A\u0005qCJ\u001cXmQ3mYR!\u0011\u0011BA\b!\u0015\u0001\u00181B*T\u0013\r\tia\u001e\u0002\u0007\u000b&$\b.\u001a:\t\u000b\u0001|\u0001\u0019A*\u0002\u0015A\f'o]3MS:,7\u000f\u0006\u0003\u0002\n\u0005U\u0001\"\u00021\u0011\u0001\u0004\u0019\u0016!\u00029beN,G\u0003BA\u0005\u00037AQ\u0001Y\tA\u0002M\u0003")
public class MagicParser {
    private final MagicManager magicManager;
    private final Regex magicRegex;
    private final String kernelObjectName;

    private MagicManager magicManager() {
        return this.magicManager;
    }

    private Regex magicRegex() {
        return this.magicRegex;
    }

    public String kernelObjectName() {
        return this.kernelObjectName;
    }

    private boolean isLineMagic(String codeLine) {
        return codeLine.startsWith("%") && !this.isCellMagic(codeLine);
    }

    private boolean isCellMagic(String codeBlob) {
        return codeBlob.startsWith("%%");
    }

    public Option<Tuple2<String, String>> parseMagic(String codeBlob) {
        None$ none$;
        Option matchData = this.magicRegex().findFirstMatchIn((CharSequence)codeBlob);
        Option option2 = matchData;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Regex.Match m3 = (Regex.Match)some.value();
            none$ = new Some((Object)new Tuple2((Object)m3.group(1), (Object)((Object)m3.after(1)).toString().trim()));
        } else if (None$.MODULE$.equals(option2)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option2);
        }
        return none$;
    }

    public boolean isValidLineMagic(String codeLine) {
        boolean bl;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option2 = this.parseMagic(codeLine);
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            String magicName = (String)tuple2._1();
            bl = this.isLineMagic(codeLine) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.magicManager().isLineMagic(this.magicManager().findMagic(magicName))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        return bl;
    }

    public List<String> parseOutInvalidMagics(String codeBlob) {
        List lineMagics = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codeBlob.split("\n"))).toList().filter((Function1 & Serializable & scala.Serializable)codeLine -> BoxesRunTime.boxToBoolean((boolean)this.isLineMagic(codeLine)));
        return (List)((List)lineMagics.filterNot((Function1 & Serializable & scala.Serializable)codeLine -> BoxesRunTime.boxToBoolean((boolean)this.isValidLineMagic(codeLine)))).map((Function1 & Serializable & scala.Serializable)line -> {
            void var3_5;
            String magicName;
            Tuple2 tuple2 = (Tuple2)this.parseMagic((String)line).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string2 = magicName = (String)tuple2._1();
            String magicName2 = string2;
            return var3_5;
        }, List$.MODULE$.canBuildFrom());
    }

    public String substitute(String magicName, String args) {
        return new StringBuilder(9).append(this.kernelObjectName()).append(".").append(magicName).append("(\"\"\"").append(args).append("\"\"\")").toString();
    }

    public String substituteLine(String codeLine) {
        String string2;
        boolean bl = this.isValidLineMagic(codeLine);
        if (bl) {
            Tuple2 tuple2 = (Tuple2)this.parseMagic(codeLine).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String magicName = (String)tuple2._1();
            String args = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)magicName, (Object)args);
            Tuple2 tuple23 = tuple22;
            String magicName2 = (String)tuple23._1();
            String args2 = (String)tuple23._2();
            string2 = this.substitute(magicName2, args2);
        } else if (!bl) {
            string2 = codeLine;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return string2;
    }

    public Either<String, String> parseCell(String codeBlob) {
        Left left;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option2 = this.parseMagic(codeBlob.trim());
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            Left left2;
            String cellMagicName = (String)tuple2._1();
            String args = (String)tuple2._2();
            Try m3 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.magicManager().findMagic(cellMagicName));
            boolean bl = BoxesRunTime.unboxToBoolean((Object)m3.map((Function1 & Serializable & scala.Serializable)magic -> BoxesRunTime.boxToBoolean((boolean)MagicParser.$anonfun$parseCell$2(this, magic))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            if (bl) {
                left2 = package$.MODULE$.Left().apply((Object)this.substitute(cellMagicName, args));
            } else if (!bl) {
                left2 = package$.MODULE$.Right().apply((Object)new StringBuilder(22).append("Magic ").append(cellMagicName).append(" does not exist!").toString());
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            left = left2;
        } else if (None$.MODULE$.equals(option2)) {
            left = package$.MODULE$.Left().apply((Object)codeBlob);
        } else {
            throw new MatchError(option2);
        }
        return left;
    }

    public Either<String, String> parseLines(String codeBlob) {
        Right right;
        List<String> invalidMagics = this.parseOutInvalidMagics(codeBlob.trim());
        List<String> list2 = invalidMagics;
        if (Nil$.MODULE$.equals(list2)) {
            String[] substitutedCode = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codeBlob.trim().split("\n"))).map((Function1 & Serializable & scala.Serializable)codeLine -> this.substituteLine((String)codeLine), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            right = package$.MODULE$.Left().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])substitutedCode)).mkString("\n"));
        } else {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(23).append("Magics [").append(invalidMagics.mkString(", ")).append("] do not exist!").toString());
        }
        return right;
    }

    public Either<String, String> parse(String codeBlob) {
        Either<String, String> either2;
        String trimCodeBlob = codeBlob.trim();
        boolean bl = this.isCellMagic(trimCodeBlob);
        if (bl) {
            either2 = this.parseCell(trimCodeBlob);
        } else if (!bl) {
            either2 = this.parseLines(trimCodeBlob);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return either2;
    }

    public static final /* synthetic */ boolean $anonfun$parseCell$2(MagicParser $this, Magic magic) {
        return $this.magicManager().isCellMagic(magic);
    }

    public MagicParser(MagicManager magicManager) {
        this.magicManager = magicManager;
        this.magicRegex = new StringOps(Predef$.MODULE$.augmentString("^[%]{1,2}(\\w*)")).r();
        this.kernelObjectName = "kernel.magics";
    }
}

