(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.directive('dashboardExportForm', function(GRAPHIC_EXPORT_OPTIONS, WT1, GraphicImportService, translate) {
        return {
            replace: false,
            require: '^form',
            restrict: 'EA',
            scope: {
                params: '=',
                origin: '@origin',
                pageIdx: '=?'
            },
            templateUrl: '/templates/dashboards/export-form.html',
            link: function($scope, element, attrs, formCtrl) {
                WT1.event('dashboard-export-form-displayed', {});

                const gridOrWindowWidth = function() {
                    if (document.querySelector('.dashboard-export-grid') != null) {
                        // Add css margin of 5 and 5 for each side
                        return Math.round(Math.max(960, document.querySelector('.dashboard-export-grid').getBoundingClientRect().width + 10));
                    } else {
                        return Math.round(Math.max(960, window.outerWidth));
                    }
                };

                $scope.translate = translate;

                $scope.exportFormController = formCtrl;
                // Utilities that give us all the choices possible
                $scope.paperSizeMap = GRAPHIC_EXPORT_OPTIONS.paperSizeMap;
                $scope.orientationMap = GRAPHIC_EXPORT_OPTIONS.orientationMap;
                $scope.fileTypes = GRAPHIC_EXPORT_OPTIONS.fileTypes;
                $scope.translatedOrientationMap = buildTranslatedOrientationMap();

                $scope.minResW = 960;
                $scope.minResH = 540;
                $scope.maxResW = 7200;
                $scope.maxResH = 10000;
                $scope.selectedDashboard = {};

                // Parameters of the export
                if (angular.isUndefined($scope.params.exportFormat)) {
                    $scope.params.exportFormat = {
                        paperSize: 'A4',
                        orientation: 'LANDSCAPE',
                        fileType: 'PDF',
                        width: ($scope.origin == 'modal') ? gridOrWindowWidth('LANDSCAPE') : 1920
                    };
                    $scope.params.exportFormat.height = GraphicImportService.computeHeight($scope.params.exportFormat.width, $scope.params.exportFormat.paperSize);
                }

                $scope.$watch('params.exportFormat.paperSize', function(newVal, oldVal) {
                    if (newVal !== oldVal) {
                        if (newVal != 'CUSTOM') {
                            $scope.params.exportFormat.width = ($scope.origin == 'modal') ? gridOrWindowWidth() :
                                $scope.params.exportFormat.orientation == 'PORTRAIT' ? 1080 : 1920;
                            $scope.params.exportFormat.height = GraphicImportService.computeHeight($scope.params.exportFormat.width, $scope.params.exportFormat.paperSize, $scope.params.exportFormat.orientation);
                        }
                    }
                });

                function buildTranslatedOrientationMap() {
                    return Object.fromEntries(
                        Object.entries(GRAPHIC_EXPORT_OPTIONS.orientationMap).map(
                            ([key]) => [key, $scope.translate(`DASHBOARD.EXPORT_MODAL.FORM.ORIENTATION.${key}`)]
                        )
                    );
                }
            }
        };
    });
})();
