(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('multivaluedStdAggrMeasureZone', function($parse, ChartFeatures, Ng2MenuOrchestratorService, ChartColorUtils) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multivalued-std-aggr-measure-zone/multivalued-std-aggr-measure-zone.directive.html',
            scope: true,
            controller: 'StdAggregatedMeasureController',
            link: function($scope, _element, attrs) {
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.chartDefKey = attrs.chartDefKey;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.direction = attrs.direction;
                $scope.shouldDisplayMultiPlotDisplayMode = function(measure) {
                    return ChartFeatures.canSetMultiPlotDisplayMode($scope.chart.def.type)
                    && measure && measure.displayType === 'line'
                    && $scope.chart.def.genericMeasures.some(m => m.displayType === 'column')
                    && !!ChartColorUtils.getColorDimensionOrMeasure($scope.chart.def);
                };
                $scope.$watch(attrs.theme, (nv) => {
                    $scope.theme = nv;
                });

                $scope.openMatMenu = function(menuIdx, event) {
                    Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey, menuIdx, event);
                };
            }
        };
    });
})();
