(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('PieChart', PieChart);

    // (!) This service previously was in static/dataiku/js/simple_report/pies/pie.js
    function PieChart(ChartManager, ChartDataWrapperFactory, PieChartUtils, PieChartDrawer, ChartDimension, ChartColorUtils) {
        return function($container, chartDef, chartHandler, axesDef, data) {

            const chartData = ChartDataWrapperFactory.chartTensorDataWrapper(data, axesDef);
            const colorDimension = ChartColorUtils.getColorDimensionOrMeasure(chartDef);
            const animationData = PieChartUtils.prepareData(chartDef, chartData);

            const numberFormattingOptions = ChartDimension.getNumberFormattingOptions(colorDimension);
            const drawFrame = function(frameIdx, chartBase) {
                animationData.frames[frameIdx].facets.forEach(function(facetData, f) {
                    const g = d3.select(chartBase.$svgs.eq(f).find('g.chart').get(0));
                    PieChartDrawer(g, chartDef, chartBase, facetData, numberFormattingOptions);
                });
            };

            ChartManager.initChart(chartDef, chartHandler, chartData, $container, drawFrame, null, { type: 'DIMENSION', name: 'color', dimension: colorDimension });

        };
    }
})();
