(function () {
    "use strict";

    const filterConditionsEditor = {
        bindings : {
            filter: '=',
            fromPrepare: '<',
            columnName: '<',
            onEnterKeydown:'<?',
            supportedFiltersOperators: '<?',
            supportedBooleanOperators: '<?',
            enumValuesProvider:'<?'
        },
        templateUrl: "/static/dataiku/nested-filters/filter-conditions-editor/filter-conditions-editor.component.html",
        controller: function filterConditionsEditorController($scope, $element, $attrs, Expressions, FiltersService, FilterConditionsEditorService, translate) {
            const ctrl = this;
            let opss = {};
            
            ctrl.$onChanges = function(changes) {
                if ("supportedBooleanOperators" in changes) {
                    opss = {};
                }
                $scope.enumValuesProvider = ctrl.enumValuesProvider;
                $scope.supportedBooleanOperators = ctrl.supportedBooleanOperators;
                if ($scope.supportedBooleanOperators.length === 1 && $scope.filter) {
                    $scope.filter.mode = $scope.supportedBooleanOperators[0];
                }
                const mapToString = {
                    "&&": ["FILTER.AND", "And"],
                    "||": ["FILTER.OR", "Or"]
                }
                $scope.booleanOptions = $scope.supportedBooleanOperators.map(so => [so, translate(mapToString[so][0], mapToString[so][1])]);
                
            }
            ctrl.$onInit = function () {
                $scope.translate = translate;
                let defaults = {
                    filter: {"conditions": [], "mode": "&&", "nestedFilters": []},
                    fromPrepare: false,
                    columnName: ""
                };
                $.each(defaults, function(param, value) {
                    if (param in ctrl) {
                        $scope[param] = ctrl[param] || value;
                    } else {
                        $scope[param] = value;
                    }
                });
                $scope.mapGeoOperators = function() {
                    $scope.filter.conditions.forEach(c => {
                        let col = FilterConditionsEditorService.getColumn($scope.$parent, c.input);
                        if (col && (col.type === "geometry" || col.type === "geopoint")) {
                                switch(c.operator) {
                                    case "is empty":
                                        c.operator = "empty string";
                                        break;
                                    case "not empty":
                                        c.operator = "not empty string";
                                        break;
                                    default:
                                        break;
                                }
                        }
                    });
                }
                $scope.mapGeoOperators();
                $scope.conditions = $scope.filter.conditions;
                $scope.rootNestedFilters = $scope.$parent.rootNestedFilters;
                $scope.filterDesc = $scope.$parent.filterDesc;
                $scope.columns = FiltersService.getColumns($scope.$parent);
                $scope.error = null;
                if ($scope.conditions.length) {
                    const datasetColumns = new Set($scope.columns.map(c => c.name));
                    if ($scope.conditions.some(condition => condition?.input && !datasetColumns.has(condition.input))) {
                        $scope.error = translate("FILTER.CONDITION.COLUMN_REPLACED_WARNING", "One or more columns have been replaced in this condition due to a schema change");
                    }
                }
                
                $scope.filteredRightColumns = {};

                $scope.filter.$filterId = Date.now()*Math.random(100);
                if($scope.fromPrepare) {
                    setTimeout(function () {$scope.setFocusById($scope.filter.$filterId + '-cond-0-' + $scope.getOperatorType($scope.conditions[0]))}, 0);
                }
                $scope.computeCanTurnIntoGroup = function () {
                    if ($scope.filter.recursionDepth===0) {
                        return (($scope.filter.nestedFilters.length>0) || ($scope.filter.conditions.length>0));
                    } else {
                        return $scope.filter.conditions.length>1;
                    }
                }
    
                $scope.canTurnIntoGroup = $scope.computeCanTurnIntoGroup();

                $scope.onEnterKeyDownParam = ctrl.onEnterKeydown || function(event, index) {
                        if (event.keyCode === 13 && index+1 === $scope.conditions.length) {
                            const newCondition = {num: 0, items: []};
                            FilterConditionsEditorService.update($scope.$parent,newCondition, $scope.fromPrepare);
                            $scope.conditions.splice(index+1,0, newCondition);
                        }
                };
                $scope.leftColumns = $scope.getColumns().filter(col => col.column !== "right");
                $scope.rightColumns = $scope.getColumns().filter(col => col.column !== "left");
                $scope.conditions.forEach(c => {
                    $scope.updateFilteredRightColumns(c);
                });
            }
            
            $scope.visualFilterHeader = ($scope.$parent.filterHeader) ? $scope.$parent.filterHeader : "Where";
            $scope.populateWithDefaults = function(cond) {
                let today = (new Date()).toISOString().split('T')[0];
                if ($scope.operatorHasParam(cond.operator, 'date')) {
                    cond.date = cond.date || today;
                    cond.time = cond.time || "00:00";
                }
                if ($scope.operatorHasParam(cond.operator, 'date2')) {
                    cond.date2 = cond.date2 || today;
                    cond.time2 = cond.time2 || "00:00";
                }
            }

            $scope.getColumns = function() {
                return FiltersService.getColumns($scope.$parent);
            };
            
            $scope.updateFilteredRightColumns = function(condition) {
                // only keep columns that fit the left column's type if any
                const selectedLeftColumn = $scope.leftColumns.find(c => c.name === condition.input);
                if (selectedLeftColumn && selectedLeftColumn.type) {
                    $scope.filteredRightColumns[condition.input] = $scope.rightColumns.filter(c => c.type && c.type === selectedLeftColumn.type);
                }
            };

            $scope.getColumn = function(name){
                return $scope.getColumns().find(col => col.name == name);
            };

            /* returns an array of operators that can act on a variable with specified type */
            $scope.getOperators = function (type) {
                if (type in opss) return opss[type];
                let operators = Expressions.getOperators(type);
                if (ctrl.supportedFiltersOperators) {
                    operators = operators.filter(ctrl.supportedFiltersOperators);
                }
                opss[type] = operators;
                return opss[type];
            };

            $scope.dateUnits = Expressions.dateUnits;

            let ocs = {};
            /* returns a list of String indicating the category (for now: "column" or "") */
            $scope.getOperatorsCategories = function(type) {
                if (type in ocs) return ocs[type];
                ocs[type] = $scope.getOperators(type).map(op => op.params.includes("col") || op.subParams && op.subParams.includes("col")  ? translate("FILTER.CONDITION.COLUMN", "column") : "");
                return ocs[type];
            };

            $scope.getFilteredOperators = function() {
                return $scope.getOperators('num').filter(operator => !$scope.operatorHasParam(operator.name,'col'));
            }

            $scope.getOperator = function(name){
                return Expressions.getOperators().find(op => op.name === name);
            };

            $scope.operatorHasParam = function(operatorName, paramName){
                if (!operatorName) return false;
                return $scope.getOperator(operatorName).params.includes(paramName);
            };

            $scope.operatorHasSubParam = function(operatorName, paramName){
                if (!operatorName) return false;
                if(angular.isUndefined($scope.getOperator(operatorName).subParams)) return false;
                return $scope.getOperator(operatorName).subParams.includes(paramName);
            };

            $scope.setFocusById = function(elementId) {
                var element = document.getElementById(elementId);
                if (element) { element.focus();}
            }

            $scope.getOperatorType = function(condition) {
                if ($scope.operatorHasParam(condition.operator, 'num')) {
                    return "num";
                } else if ($scope.operatorHasParam(condition.operator, 'string')) {
                    return "string";
                } else if ($scope.operatorHasParam(condition.operator, 'date')) {
                    return "date";
                } else {
                    return "num";
                }
            }

            $scope.getPrepareOperatorAppliesTo = function(operatorLabel) {
                return Expressions.getOperatorLabelAppliesTo(operatorLabel);
            }

            $scope.prepareOperatorsLabels = [];
            $scope.getOperatorsLabelsPrepareRecipe = function() {
                if ($scope.prepareOperatorsLabels.length==0) {
                    $scope.prepareOperatorsLabels = Expressions.getOperatorsLabelsPrepareRecipe();
                }
                return $scope.prepareOperatorsLabels;
            }

            $scope.prepareOperators = [];
            $scope.getOperatorsPrepareRecipe = function() {
                if ($scope.prepareOperators.length==0) {
                    $scope.prepareOperators = Expressions.getOperatorsPrepareRecipe();
                }
                return $scope.prepareOperators;
            }

            $scope.getColumnGenericType = function(name) {
                if (!name) return;
                let col = FilterConditionsEditorService.getColumn($scope.$parent, name);
                if (!col) return;
                return Expressions.genericType(col.type);
            };

            $scope.remove = function(index){
                if($scope.conditions.length!==0 || $scope.filterDesc.nestedFilters.length!==0){
                    $scope.conditions.splice(index, 1);
                }
            };

            $scope.duplicate = function(index){
                let newCondition = {num:0, items: []};
                newCondition.col = $scope.conditions[index].col;
                newCondition.input = $scope.conditions[index].input;
                newCondition.num = $scope.conditions[index].num;
                newCondition.operator = $scope.conditions[index].operator;
                newCondition.items = angular.copy($scope.conditions[index].items);
                const attributes = ['string', 'time', 'date', 'unit', 'time2', 'date2'];

                attributes.forEach(attr => {
                    if (attr in $scope.conditions[index]) {
                        newCondition[attr] = $scope.conditions[index][attr];
                    }
                });
                FilterConditionsEditorService.update($scope.$parent,newCondition, $scope.fromPrepare);
                $scope.conditions.splice(index+1,0, newCondition);
            }

            $scope.turnIntoGroup = function(index) {
                $scope.filter.nestedFilters.splice(0,0,{
                                                       "conditions": [$scope.conditions[index]],
                                                       "recursionDepth": $scope.filter.recursionDepth+1,
                                                       "nestedFilters": [],
                                                       "mode": $scope.filter.mode==="&&" ? "||" : "&&",
                                                       "position": $scope.filter.nestedFilters.length,
                                                       "parentPosition": $scope.$parent.nestedFilters[0].position
                                                        }
                );
                $scope.conditions.splice(index, 1);
            }

            $scope.initialiseAllData = function() {
                $scope.conditions.forEach(c => {
                    FilterConditionsEditorService.update($scope.$parent,c, $scope.fromPrepare);
                    if ($scope.operatorHasParam(c.operator, 'list')) {
                        c.items = c.items || [];
                    }
                    $scope.updateFilteredRightColumns(c);
                });
            }

            $scope.toggleList = function(c, index) {
                c.$showList = !c.$showList;

                setTimeout(function () {
                    if(c.$showList){
                        $scope.computeDimensionsOnFilterEditor(index);
                    }
                }, 0);
            };

            $scope.getValueListDescription = function(c) {
                const nbValues = c.items ? c.items.length : 0;
                if(nbValues === 0){
                    return "";
                }else if(nbValues === 1){
                    return $scope.translate("FILTER.ADD_VALUE.ONE_VALUE", "1 value");
                }
                return c.items.length + $scope.translate("FILTER.ADD_VALUE._VALUES", " values");
            }

            $scope.addConditionValue = function(conditionIndex) {
                if($scope.conditions[conditionIndex].items === undefined){
                  $scope.conditions[conditionIndex].items = [];
                }
                $scope.conditions[conditionIndex].items.push({num: 0})
                FilterConditionsEditorService.update($scope.$parent, $scope.conditions[conditionIndex], $scope.fromPrepare);
                setTimeout(function () {
                   $scope.computeDimensionsOnFilterEditor(conditionIndex);
                }, 0);
            }

            $scope.removeConditionValue = function(conditionIndex, index){
                 if($scope.conditions[conditionIndex].items.length !== 0){
                     $scope.conditions[conditionIndex].items.splice(index, 1);
                     FilterConditionsEditorService.update($scope.$parent, $scope.conditions[conditionIndex], $scope.fromPrepare);
                 }
            };

            $scope.computeDimensionsOnFilterEditor = function(index){
                let itemContainerElement = document.getElementById($scope.filter.$filterId + '-cond-' + index + '-item-container');
                let itemContainerInputElement = document.getElementById($scope.filter.$filterId + '-cond-' + index + '-item-container-input');
                let itemContainerInputElementClientRect = itemContainerInputElement.getBoundingClientRect();
                let itemContainerPaddingBottom = parseInt(getComputedStyle(itemContainerElement).getPropertyValue('padding-bottom'));
                let itemContainerTop = itemContainerInputElementClientRect.bottom;
                itemContainerElement.style.left = itemContainerInputElementClientRect.left + 'px';
                itemContainerElement.style.top = itemContainerTop + 'px';
                itemContainerElement.style.maxHeight = window.innerHeight - itemContainerTop - itemContainerPaddingBottom + 'px';
            }

            /* Watchers */

            $scope.$watch("hasSchema()", function(nv, ov) {
                if (nv && nv!==ov && $scope.filterDesc.enabled) {
                    $scope.initialiseAllData();
                }
            });

            $scope.$watch("filterDesc.enabled", function(nv, ov) {
                if (nv && FiltersService.hasSchema($scope.$parent)) {
                    $scope.initialiseAllData();
                }
            });

            $scope.$watch("filter", function(nv, ov) {
                
                if (nv !== ov) {
                    $scope.conditions = $scope.filter.conditions;
                    $scope.canTurnIntoGroup = $scope.computeCanTurnIntoGroup();
                }

                if (nv.conditions && ov.conditions) {
                    nv.conditions.forEach((newCond, index) => {
                        const oldCond = ov.conditions[index];
                        if (!oldCond || newCond.input !== oldCond.input) {
                            $scope.updateFilteredRightColumns(newCond);
                        }
                    });
                }


                if(nv.conditions.length !== ov.conditions.length && nv.conditions.length>0 && $scope.fromPrepare) {
                    setTimeout(function () {$scope.setFocusById($scope.filter.$filterId + '-cond-' + String(nv.conditions.length-1) + '-' + $scope.getOperatorType(nv.conditions[nv.conditions.length-1]))}, 0);
                }

            }, true);
            
            // $scope.$watch("conditions", () => {
            //     $scope.error = null;
            // })

            $scope.formatedColName = function(col) {
                return col.name + ' ('+col.type+')';
            };
        },
    };

    angular.module("dataiku.nestedFilters").component("filterConditionsEditor", filterConditionsEditor);
})();
