/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features treemap', function () {

    const chartType = 'treemap';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
    });

    it('has left menu filters dropzone', function () {
        ChartFeaturesTestUtils.setYDimensionFromAlphanumericalColumns();
        ChartFeaturesTestUtils.setXYGenericFromNumericalColumns();
        ChartFeaturesTestUtils.initDiscreteLegends();
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        //filter
        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');

        //legend
        expectIdToBeVisible('qa_charts_legends-submenu-header');
    });

    it('does not have left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeHidden('qa_charts_animation-submenu-header');
        expectIdToBeHidden('qa_charts_animation-dropzone');
        expectIdToBeHidden('qa_charts_subchart-submenu-header');
        expectIdToBeHidden('qa_charts_subcharts-dropzone');
    });
   
    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});

