class BlueprintVersion:
    """
    Instantiate a new Govern blueprint version.

    :param str json: A Python dict containing the blueprint version data.
        This class is actually mostly a wrapper around that json dict.
    """
    def __init__(self, json):
        self.json = json

    @property
    def id(self):
        """
        Return the blueprint version id.

        :return: the blueprint version id as a Python dict.
            A blueprint version id consists of a blueprint id and a blueprint version id.
        """
        if 'id' not in self.json:
            raise Exception("id not set for blueprintVersion {name}".format(name=self.name))
        return self.json.get('id')

    @property
    def name(self):
        """
        Return the blueprint version name.

        :return: the blueprint version name as a Python str
        """
        return self.json.get('name')

    @property
    def fieldDefinitions(self):
        """
        Return the field definitions.

        :return: the field definitions as a Python dict
        """
        return self.json.get('fieldDefinitions', {})
