#' Get information about this connection.
#'
#' Calling this method requires permission to read connection details
#'
#' Returns a named list containing:
#'   - type: the type of the connection
#'   - params: a named list of the raw params of the connection
#'   - (optional) resolvedBasicCredential: a named list containing "user" and "password" if
#'      this connection has a basic credential
#'   - (optional) resolvedAWSCredential: if this connection is an AWS connection, a named list
#'.        containing "accessKey", "secretKey" and optionally "sessionToken" (if the AWS token is a STS token)
#'
#' @param name the name of the connection
#' @export
dkuGetConnectionInfo <- function(name) {
    .dku_publicapi__request(GET, paste0("/connections/", name, "/info"))
}