/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.trie;

import java.util.ArrayList;
import java.util.List;

public class Trie {
    private Node root = new Node();

    public void add(String value) {
        this.root.add(value, true);
    }

    public Node getRoot() {
        return this.root;
    }

    public class Node {
        private char key;
        private List<Node> children = new ArrayList<Node>();

        public Node() {
        }

        public Node(char key) {
            this.key = key;
        }

        public void add(String value) {
            this.add(value, false);
        }

        public void add(String value, boolean terminate) {
            if (value.length() == 0) {
                return;
            }
            Node node = this.addChild(new Node(value.charAt(0)));
            for (int i = 1; i < value.length(); ++i) {
                node = node.addChild(new Node(value.charAt(i)));
            }
            if (terminate && node != null) {
                node.addChild(new Node('\u0001'));
            }
        }

        public Node addChild(Node newNode) {
            Node child = this.getChild(newNode.getKey());
            if (child == null) {
                this.children.add(newNode);
                child = newNode;
            }
            return child;
        }

        public char getKey() {
            return this.key;
        }

        public boolean hasSinglePath() {
            switch (this.children.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return this.children.get(0).hasSinglePath();
                }
            }
            return false;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        private Node getChild(char key) {
            for (Node child : this.children) {
                if (child.getKey() != key) continue;
                return child;
            }
            return null;
        }
    }
}

