/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth;

import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.X509CertUtils;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.cnf.AbstractConfirmation;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class X509CertificateConfirmation
extends AbstractConfirmation {
    private final Base64URL x5tS256;

    public X509CertificateConfirmation(Base64URL x5tS256) {
        this.x5tS256 = Objects.requireNonNull(x5tS256);
    }

    public Base64URL getValue() {
        return this.x5tS256;
    }

    @Override
    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject cnf = new JSONObject();
        cnf.put("x5t#S256", this.x5tS256.toString());
        return new AbstractMap.SimpleImmutableEntry<String, JSONObject>("cnf", cnf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509CertificateConfirmation)) {
            return false;
        }
        X509CertificateConfirmation that = (X509CertificateConfirmation)o;
        return this.x5tS256.equals(that.x5tS256);
    }

    public int hashCode() {
        return Objects.hash(this.x5tS256);
    }

    public static X509CertificateConfirmation parse(JWTClaimsSet jwtClaimsSet) {
        JSONObject cnf = X509CertificateConfirmation.parseConfirmationJSONObject(jwtClaimsSet);
        if (cnf == null) {
            return null;
        }
        return X509CertificateConfirmation.parseFromConfirmationJSONObject(cnf);
    }

    public static X509CertificateConfirmation parse(JSONObject jsonObject) {
        if (!jsonObject.containsKey("cnf")) {
            return null;
        }
        try {
            return X509CertificateConfirmation.parseFromConfirmationJSONObject(JSONObjectUtils.getJSONObject(jsonObject, "cnf"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static X509CertificateConfirmation parseFromConfirmationJSONObject(JSONObject cnf) {
        if (cnf == null) {
            return null;
        }
        try {
            String x5tString = JSONObjectUtils.getNonBlankString(cnf, "x5t#S256");
            return new X509CertificateConfirmation(new Base64URL(x5tString));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static X509CertificateConfirmation of(X509Certificate x509Cert) {
        return new X509CertificateConfirmation(X509CertUtils.computeSHA256Thumbprint(x509Cert));
    }
}

