/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.transform.util;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectWriter;
import com.github.fge.jackson.JacksonUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class APIFileDownload {
    private static final Path RESOURCE_PATH;
    private static final ObjectMapper MAPPER;
    private static final ObjectWriter JSONWRITER;

    private APIFileDownload() {
    }

    public static void main(String ... args2) throws IOException {
        if (args2.length != 2) {
            System.err.println("Requiring two arguments (URL, destination)");
            System.exit(2);
        }
        URL source = new URL(args2[0]);
        Path dstFile = RESOURCE_PATH.resolve(args2[1]).toAbsolutePath();
        if (!dstFile.startsWith(RESOURCE_PATH)) {
            System.err.println("Illegal destination path " + dstFile);
            System.exit(2);
        }
        Files.createDirectories(dstFile.getParent(), new FileAttribute[0]);
        try (InputStream in = source.openStream();
             BufferedWriter writer = Files.newBufferedWriter(dstFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            JsonNode node = MAPPER.readTree(in);
            JSONWRITER.writeValue(writer, (Object)node);
        }
    }

    static {
        MAPPER = JacksonUtils.newMapper();
        JSONWRITER = MAPPER.writerWithDefaultPrettyPrinter();
        try {
            RESOURCE_PATH = Paths.get("src/main/resources/samples", new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

