/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.configuration2;

import com.dataiku.dss.shadelib.org.apache.commons.configuration2.AbstractConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.Configuration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.convert.ListDelimiterHandler;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.util.Iterator;
import java.util.Objects;

public class SubsetConfiguration
extends AbstractConfiguration {
    protected Configuration parent;
    protected String prefix;
    protected String delimiter;

    public SubsetConfiguration(Configuration parent, String prefix) {
        this(parent, prefix, null);
    }

    public SubsetConfiguration(Configuration parent, String prefix, String delimiter) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.initInterpolator();
    }

    @Override
    public void addPropertyDirect(String key, Object value) {
        this.parent.addProperty(this.getParentKey(key), value);
    }

    @Override
    protected void clearPropertyDirect(String key) {
        this.parent.clearProperty(this.getParentKey(key));
    }

    @Override
    protected boolean containsKeyInternal(String key) {
        return this.parent.containsKey(this.getParentKey(key));
    }

    @Override
    protected boolean containsValueInternal(Object value) {
        return this.parent.containsValue(value);
    }

    protected String getChildKey(String key) {
        if (!key.startsWith(this.prefix)) {
            throw new IllegalArgumentException("The parent key '" + key + "' is not in the subset.");
        }
        String modifiedKey = null;
        if (key.length() == this.prefix.length()) {
            modifiedKey = "";
        } else {
            int i = this.prefix.length() + (this.delimiter != null ? this.delimiter.length() : 0);
            modifiedKey = key.substring(i);
        }
        return modifiedKey;
    }

    @Override
    protected Iterator<String> getKeysInternal() {
        return new SubsetIterator(this.parent.getKeys(this.prefix, this.delimiter));
    }

    @Override
    protected Iterator<String> getKeysInternal(String prefix) {
        return new SubsetIterator(this.parent.getKeys(this.getParentKey(prefix)));
    }

    @Override
    public ListDelimiterHandler getListDelimiterHandler() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).getListDelimiterHandler() : super.getListDelimiterHandler();
    }

    public Configuration getParent() {
        return this.parent;
    }

    protected String getParentKey(String key) {
        if (StringUtils.isEmpty(key)) {
            return this.prefix;
        }
        return this.delimiter == null ? this.prefix + key : this.prefix + this.delimiter + key;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    protected Object getPropertyInternal(String key) {
        return this.parent.getProperty(this.getParentKey(key));
    }

    private void initInterpolator() {
        this.getInterpolator().setParentInterpolator(this.getParent().getInterpolator());
    }

    @Override
    protected boolean isEmptyInternal() {
        return !this.getKeysInternal().hasNext();
    }

    @Override
    public boolean isThrowExceptionOnMissing() {
        if (this.parent instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)this.parent).isThrowExceptionOnMissing();
        }
        return super.isThrowExceptionOnMissing();
    }

    @Override
    public void setListDelimiterHandler(ListDelimiterHandler listDelimiterHandler) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setListDelimiterHandler(listDelimiterHandler);
        } else {
            super.setListDelimiterHandler(listDelimiterHandler);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setThrowExceptionOnMissing(throwExceptionOnMissing);
        } else {
            super.setThrowExceptionOnMissing(throwExceptionOnMissing);
        }
    }

    @Override
    public Configuration subset(String prefix) {
        return this.parent.subset(this.getParentKey(prefix));
    }

    private final class SubsetIterator
    implements Iterator<String> {
        private final Iterator<String> parentIterator;

        public SubsetIterator(Iterator<String> it) {
            this.parentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public String next() {
            return SubsetConfiguration.this.getChildKey(this.parentIterator.next());
        }

        @Override
        public void remove() {
            this.parentIterator.remove();
        }
    }
}

