/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class StemmerOverrideFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "stemmerOverride";
    private StemmerOverrideFilter.StemmerOverrideMap dictionary;
    private final String dictionaryFiles;
    private final boolean ignoreCase;

    public StemmerOverrideFilterFactory(Map<String, String> args2) {
        super(args2);
        this.dictionaryFiles = this.get(args2, "dictionary");
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public StemmerOverrideFilterFactory() {
        throw StemmerOverrideFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files;
        if (this.dictionaryFiles != null && (files = this.splitFileNames(this.dictionaryFiles)).size() > 0) {
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(this.ignoreCase);
            for (String file : files) {
                List<String> list = this.getLines(loader, file.trim());
                for (String line : list) {
                    String[] mapping = line.split("\t", 2);
                    builder.add(mapping[0], mapping[1]);
                }
            }
            this.dictionary = builder.build();
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.dictionary == null ? input : new StemmerOverrideFilter(input, this.dictionary);
    }
}

