/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.te;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopwordAnalyzerBase;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.WordlistLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.DecimalDigitFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.in.IndicNormalizationFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.te.TeluguNormalizationFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.te.TeluguStemFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class TeluguAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public TeluguAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    public TeluguAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public TeluguAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new DecimalDigitFilter(source);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter(result);
        result = new TeluguNormalizationFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new TeluguStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new DecimalDigitFilter(in);
        result = new IndicNormalizationFilter(result);
        result = new TeluguNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(TeluguAnalyzer.class.getResourceAsStream(TeluguAnalyzer.DEFAULT_STOPWORD_FILE), TeluguAnalyzer.DEFAULT_STOPWORD_FILE), TeluguAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

