/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.BinaryRangeDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.document.RangeFieldQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

abstract class BinaryRangeFieldRangeQuery
extends Query {
    private final String field;
    private byte[] queryPackedValue;
    private final int numBytesPerDimension;
    private final ArrayUtil.ByteArrayComparator comparator;
    private final int numDims;
    private final RangeFieldQuery.QueryType queryType;

    BinaryRangeFieldRangeQuery(String field, byte[] queryPackedValue, int numBytesPerDimension, int numDims, RangeFieldQuery.QueryType queryType) {
        this.field = field;
        this.queryPackedValue = queryPackedValue;
        this.numBytesPerDimension = numBytesPerDimension;
        this.comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
        this.numDims = numDims;
        if (queryType != RangeFieldQuery.QueryType.INTERSECTS) {
            throw new UnsupportedOperationException("INTERSECTS is the only query type supported for this field type right now");
        }
        this.queryType = queryType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BinaryRangeFieldRangeQuery that = (BinaryRangeFieldRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.queryPackedValue, that.queryPackedValue);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Arrays.hashCode(this.queryPackedValue);
        return h2;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private BinaryRangeDocValues getValues(LeafReader reader, String field) throws IOException {
        if (reader.getFieldInfos().fieldInfo(field) == null) {
            return null;
        }
        return new BinaryRangeDocValues(DocValues.getBinary(reader, field), this.numDims, this.numBytesPerDimension);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final BinaryRangeDocValues values2 = BinaryRangeFieldRangeQuery.this.getValues(context.reader(), BinaryRangeFieldRangeQuery.this.field);
                if (values2 == null) {
                    return null;
                }
                TwoPhaseIterator iterator2 = new TwoPhaseIterator(values2){

                    @Override
                    public boolean matches() {
                        return BinaryRangeFieldRangeQuery.this.queryType.matches(BinaryRangeFieldRangeQuery.this.queryPackedValue, values2.getPackedValue(), BinaryRangeFieldRangeQuery.this.numDims, BinaryRangeFieldRangeQuery.this.numBytesPerDimension, BinaryRangeFieldRangeQuery.this.comparator);
                    }

                    @Override
                    public float matchCost() {
                        return BinaryRangeFieldRangeQuery.this.queryPackedValue.length;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator2);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, BinaryRangeFieldRangeQuery.this.field);
            }
        };
    }
}

