/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValuesType;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexOptions;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.VectorEncoding;
import com.dataiku.dss.shadelib.org.apache.lucene.index.VectorSimilarityFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntObjectHashMap;
import com.dataiku.dss.shadelib.org.apache.lucene.util.CollectionUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Version;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FieldInfos
implements Iterable<FieldInfo> {
    public static final FieldInfos EMPTY = new FieldInfos(new FieldInfo[0]);
    private final boolean hasFreq;
    private final boolean hasPostings;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final boolean hasVectorValues;
    private final String softDeletesField;
    private final String parentField;
    private final FieldInfo[] byNumber;
    private final HashMap<String, FieldInfo> byName;
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasVectors = false;
        boolean hasPostings = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        boolean hasVectorValues = false;
        String softDeletesField = null;
        String parentField = null;
        this.byName = CollectionUtil.newHashMap(infos.length);
        int maxFieldNumber = -1;
        boolean fieldNumberStrictlyAscending = true;
        for (FieldInfo info : infos) {
            int fieldNumber = info.number;
            if (fieldNumber < 0) {
                throw new IllegalArgumentException("illegal field number: " + info.number + " for field " + info.name);
            }
            if (maxFieldNumber < fieldNumber) {
                maxFieldNumber = fieldNumber;
            } else {
                fieldNumberStrictlyAscending = false;
            }
            FieldInfo previous = this.byName.put(info.name, info);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info.number + " have: " + info.name);
            }
            hasVectors |= info.hasVectors();
            hasPostings |= info.getIndexOptions() != IndexOptions.NONE;
            hasProx |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info.hasPayloads();
            hasPointValues |= info.getPointDimensionCount() != 0;
            hasVectorValues |= info.getVectorDimension() != 0;
            if (info.isSoftDeletesField()) {
                if (softDeletesField != null && !softDeletesField.equals(info.name)) {
                    throw new IllegalArgumentException("multiple soft-deletes fields [" + info.name + ", " + softDeletesField + "]");
                }
                softDeletesField = info.name;
            }
            if (!info.isParentField()) continue;
            if (parentField != null && !parentField.equals(info.name)) {
                throw new IllegalArgumentException("multiple parent fields [" + info.name + ", " + parentField + "]");
            }
            parentField = info.name;
        }
        this.hasVectors = hasVectors;
        this.hasPostings = hasPostings;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.hasVectorValues = hasVectorValues;
        this.softDeletesField = softDeletesField;
        this.parentField = parentField;
        if (fieldNumberStrictlyAscending && maxFieldNumber == infos.length - 1) {
            this.byNumber = infos;
            this.values = Arrays.asList(this.byNumber);
        } else {
            this.byNumber = new FieldInfo[maxFieldNumber + 1];
            for (FieldInfo fieldInfo : infos) {
                FieldInfo existing = this.byNumber[fieldInfo.number];
                if (existing != null) {
                    throw new IllegalArgumentException("duplicate field numbers: " + existing.name + " and " + fieldInfo.name + " have: " + fieldInfo.number);
                }
                this.byNumber[fieldInfo.number] = fieldInfo;
            }
            if (maxFieldNumber == infos.length - 1) {
                this.values = Arrays.asList(this.byNumber);
            } else {
                if (!fieldNumberStrictlyAscending) {
                    Arrays.sort(infos, (fi1, fi2) -> Integer.compare(fi1.number, fi2.number));
                }
                this.values = Arrays.asList(infos);
            }
        }
    }

    public static FieldInfos getMergedFieldInfos(IndexReader reader) {
        List<LeafReaderContext> leaves = reader.leaves();
        if (leaves.isEmpty()) {
            return EMPTY;
        }
        if (leaves.size() == 1) {
            return leaves.get(0).reader().getFieldInfos();
        }
        String softDeletesField = null;
        int indexCreatedVersionMajor = -1;
        for (LeafReaderContext leaf : reader.leaves()) {
            String leafSoftDeletesField = leaf.reader().getFieldInfos().softDeletesField;
            if (leafSoftDeletesField != null) {
                if (softDeletesField != null && !softDeletesField.equals(leafSoftDeletesField)) {
                    throw new IllegalArgumentException("Cannot merge segments that have been created with different soft-deletes fields; found [" + softDeletesField + " and " + leafSoftDeletesField + "]");
                }
                softDeletesField = leafSoftDeletesField;
            }
            if (leaf.reader().getMetaData() == null) continue;
            int leafVersionMajor = leaf.reader().getMetaData().getCreatedVersionMajor();
            if (indexCreatedVersionMajor != -1 && indexCreatedVersionMajor != leafVersionMajor) {
                throw new IllegalArgumentException("Cannot merge segments that have been created in different major versions; found [" + indexCreatedVersionMajor + " and " + leafVersionMajor + "]");
            }
            indexCreatedVersionMajor = leafVersionMajor;
        }
        if (indexCreatedVersionMajor == -1) {
            indexCreatedVersionMajor = Version.LATEST.major;
        }
        String parentField = FieldInfos.getAndValidateParentField(leaves);
        Builder builder = new Builder(new FieldNumbers(softDeletesField, parentField, indexCreatedVersionMajor));
        for (LeafReaderContext ctx : leaves) {
            for (FieldInfo fieldInfo : ctx.reader().getFieldInfos()) {
                builder.add(fieldInfo);
            }
        }
        return builder.finish();
    }

    private static String getAndValidateParentField(List<LeafReaderContext> leaves) {
        boolean set = false;
        String theField = null;
        for (LeafReaderContext ctx : leaves) {
            String field = ctx.reader().getFieldInfos().getParentField();
            if (set && !Objects.equals(field, theField)) {
                throw new IllegalStateException("expected parent doc field to be \"" + theField + " \" across all segments but found a segment with different field \"" + field + "\"");
            }
            theField = field;
            set = true;
        }
        return theField;
    }

    public static Collection<String> getIndexedFields(IndexReader reader) {
        return reader.leaves().stream().flatMap(l -> StreamSupport.stream(l.reader().getFieldInfos().spliterator(), false).filter(fi -> fi.getIndexOptions() != IndexOptions.NONE)).map(fi -> fi.name).collect(Collectors.toSet());
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasPostings() {
        return this.hasPostings;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public boolean hasVectorValues() {
        return this.hasVectorValues;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        return fieldNumber >= this.byNumber.length ? null : this.byNumber[fieldNumber];
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;
        private boolean finished;

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public String getSoftDeletesFieldName() {
            return this.globalFieldNumbers.softDeletesFieldName;
        }

        public String getParentFieldName() {
            return this.globalFieldNumbers.parentFieldName;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.add(fi, -1L);
        }

        FieldInfo add(FieldInfo fi, long dvGen) {
            FieldInfo curFi = this.fieldInfo(fi.getName());
            if (curFi != null) {
                FieldInfo updatedFieldInfo;
                curFi.verifySameSchema(fi, this.globalFieldNumbers.strictlyConsistent);
                if (!this.globalFieldNumbers.strictlyConsistent && (updatedFieldInfo = curFi.handleLegacySupportedUpdates(fi)) != null) {
                    if (curFi.getDocValuesType() == DocValuesType.NONE && updatedFieldInfo.getDocValuesType() != DocValuesType.NONE) {
                        this.globalFieldNumbers.setDocValuesType(updatedFieldInfo.number, updatedFieldInfo.getName(), updatedFieldInfo.getDocValuesType());
                    }
                    this.byName.put(fi.getName(), updatedFieldInfo);
                }
                if (fi.attributes() != null) {
                    fi.attributes().forEach((k, v) -> curFi.putAttribute((String)k, (String)v));
                }
                if (fi.hasPayloads()) {
                    curFi.setStorePayloads();
                }
                return curFi;
            }
            assert (this.assertNotFinished());
            int fieldNumber = this.globalFieldNumbers.addOrGet(fi);
            FieldInfo fiNew = new FieldInfo(fi.getName(), fieldNumber, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), dvGen, new HashMap<String, String>(fi.attributes()), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
            this.byName.put(fiNew.getName(), fiNew);
            return fiNew;
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        private boolean assertNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("FieldInfos.Builder was already finished; cannot add new fields");
            }
            return true;
        }

        FieldInfos finish() {
            this.finished = true;
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final IntObjectHashMap<String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, IndexOptions> indexOptions;
        private final Map<String, DocValuesType> docValuesType;
        private final Map<String, FieldDimensions> dimensions;
        private final Map<String, FieldVectorProperties> vectorProps;
        private final Map<String, Boolean> omitNorms;
        private final Map<String, Boolean> storeTermVectors;
        private int lowestUnassignedFieldNumber = -1;
        private final String softDeletesFieldName;
        private final boolean strictlyConsistent;
        private final String parentFieldName;

        FieldNumbers(String softDeletesFieldName, String parentFieldName, int indexCreatedVersionMajor) {
            this.numberToName = new IntObjectHashMap();
            this.indexOptions = new HashMap<String, IndexOptions>();
            this.docValuesType = new HashMap<String, DocValuesType>();
            this.dimensions = new HashMap<String, FieldDimensions>();
            this.vectorProps = new HashMap<String, FieldVectorProperties>();
            this.omitNorms = new HashMap<String, Boolean>();
            this.storeTermVectors = new HashMap<String, Boolean>();
            this.softDeletesFieldName = softDeletesFieldName;
            this.strictlyConsistent = indexCreatedVersionMajor >= 9;
            this.parentFieldName = parentFieldName;
            if (softDeletesFieldName != null && parentFieldName != null && parentFieldName.equals(softDeletesFieldName)) {
                throw new IllegalArgumentException("parent document and soft-deletes field can't be the same field \"" + parentFieldName + "\"");
            }
        }

        synchronized void verifyFieldInfo(FieldInfo fi) {
            String fieldName = fi.getName();
            this.verifySoftDeletedFieldName(fieldName, fi.isSoftDeletesField());
            this.verifyParentFieldName(fieldName, fi.isParentField());
            if (this.nameToNumber.containsKey(fieldName)) {
                this.verifySameSchema(fi);
            }
        }

        synchronized int addOrGet(FieldInfo fi) {
            String fieldName = fi.getName();
            this.verifySoftDeletedFieldName(fieldName, fi.isSoftDeletesField());
            this.verifyParentFieldName(fieldName, fi.isParentField());
            Integer fieldNumber = this.nameToNumber.get(fieldName);
            if (fieldNumber != null) {
                this.verifySameSchema(fi);
            } else {
                Integer preferredBoxed = fi.number;
                if (fi.number != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
                this.indexOptions.put(fieldName, fi.getIndexOptions());
                if (fi.getIndexOptions() != IndexOptions.NONE) {
                    this.storeTermVectors.put(fieldName, fi.hasVectors());
                    this.omitNorms.put(fieldName, fi.omitsNorms());
                }
                this.docValuesType.put(fieldName, fi.getDocValuesType());
                this.dimensions.put(fieldName, new FieldDimensions(fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes()));
                this.vectorProps.put(fieldName, new FieldVectorProperties(fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction()));
            }
            return fieldNumber;
        }

        private void verifySoftDeletedFieldName(String fieldName, boolean isSoftDeletesField) {
            if (isSoftDeletesField) {
                if (this.softDeletesFieldName == null) {
                    throw new IllegalArgumentException("this index has [" + fieldName + "] as soft-deletes already but soft-deletes field is not configured in IWC");
                }
                if (!fieldName.equals(this.softDeletesFieldName)) {
                    throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as soft-deletes already");
                }
            } else if (fieldName.equals(this.softDeletesFieldName)) {
                throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as non-soft-deletes already");
            }
        }

        private void verifyParentFieldName(String fieldName, boolean isParentField) {
            if (isParentField) {
                if (this.parentFieldName == null) {
                    throw new IllegalArgumentException("can't add field [" + fieldName + "] as parent document field; this IndexWriter has no parent document field configured");
                }
                if (!fieldName.equals(this.parentFieldName)) {
                    throw new IllegalArgumentException("can't add field [" + fieldName + "] as parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field");
                }
            } else if (fieldName.equals(this.parentFieldName)) {
                throw new IllegalArgumentException("can't add [" + fieldName + "] as non parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field");
            }
        }

        private void verifySameSchema(FieldInfo fi) {
            String fieldName = fi.getName();
            IndexOptions currentOpts = this.indexOptions.get(fieldName);
            FieldInfo.verifySameIndexOptions(fieldName, currentOpts, fi.getIndexOptions(), this.strictlyConsistent);
            if (currentOpts != IndexOptions.NONE) {
                boolean curStoreTermVector = this.storeTermVectors.get(fieldName);
                FieldInfo.verifySameStoreTermVectors(fieldName, curStoreTermVector, fi.hasVectors(), this.strictlyConsistent);
                boolean curOmitNorms = this.omitNorms.get(fieldName);
                FieldInfo.verifySameOmitNorms(fieldName, curOmitNorms, fi.omitsNorms(), this.strictlyConsistent);
            }
            DocValuesType currentDVType = this.docValuesType.get(fieldName);
            FieldInfo.verifySameDocValuesType(fieldName, currentDVType, fi.getDocValuesType(), this.strictlyConsistent);
            FieldDimensions dims = this.dimensions.get(fieldName);
            FieldInfo.verifySamePointsOptions(fieldName, dims.dimensionCount, dims.indexDimensionCount, dims.dimensionNumBytes, fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), this.strictlyConsistent);
            FieldVectorProperties props = this.vectorProps.get(fieldName);
            FieldInfo.verifySameVectorOptions(fieldName, props.numDimensions, props.vectorEncoding, props.similarityFunction, fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction());
        }

        synchronized void verifyOrCreateDvOnlyField(String fieldName, DocValuesType dvType, boolean fieldMustExist) {
            if (!this.nameToNumber.containsKey(fieldName)) {
                if (fieldMustExist) {
                    throw new IllegalArgumentException("Can't update [" + dvType + "] doc values; the field [" + fieldName + "] doesn't exist.");
                }
                FieldInfo fi = new FieldInfo(fieldName, -1, false, false, false, IndexOptions.NONE, dvType, -1L, new HashMap<String, String>(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, this.softDeletesFieldName != null && this.softDeletesFieldName.equals(fieldName), this.parentFieldName != null && this.parentFieldName.equals(fieldName));
                this.addOrGet(fi);
            } else {
                DocValuesType fieldDvType = this.docValuesType.get(fieldName);
                if (dvType != fieldDvType) {
                    throw new IllegalArgumentException("Can't update [" + dvType + "] doc values; the field [" + fieldName + "] has inconsistent doc values' type of [" + fieldDvType + "].");
                }
                FieldDimensions fdimensions = this.dimensions.get(fieldName);
                if (fdimensions != null && fdimensions.dimensionCount != 0) {
                    throw new IllegalArgumentException("Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with points.");
                }
                IndexOptions ioptions = this.indexOptions.get(fieldName);
                if (ioptions != null && ioptions != IndexOptions.NONE) {
                    throw new IllegalArgumentException("Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with postings.");
                }
                FieldVectorProperties fvp = this.vectorProps.get(fieldName);
                if (fvp != null && fvp.numDimensions != 0) {
                    throw new IllegalArgumentException("Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with vectors.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldInfo constructFieldInfo(String fieldName, DocValuesType dvType, int newFieldNumber) {
            Integer fieldNumber;
            FieldNumbers fieldNumbers = this;
            synchronized (fieldNumbers) {
                fieldNumber = this.nameToNumber.get(fieldName);
            }
            if (fieldNumber == null) {
                return null;
            }
            DocValuesType dvType0 = this.docValuesType.get(fieldName);
            if (dvType != dvType0) {
                return null;
            }
            boolean isSoftDeletesField = fieldName.equals(this.softDeletesFieldName);
            boolean isParentField = fieldName.equals(this.parentFieldName);
            return new FieldInfo(fieldName, newFieldNumber, false, false, false, IndexOptions.NONE, dvType, -1L, new HashMap<String, String>(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, isSoftDeletesField, isParentField);
        }

        synchronized void setDocValuesType(int number, String name, DocValuesType dvType) {
            this.verifyConsistent(number, name, dvType);
            this.docValuesType.put(name, dvType);
        }

        synchronized void verifyConsistent(Integer number, String name, DocValuesType dvType) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            DocValuesType currentDVType = this.docValuesType.get(name);
            if (dvType != DocValuesType.NONE && currentDVType != null && currentDVType != DocValuesType.NONE && dvType != currentDVType) {
                throw new IllegalArgumentException("cannot change DocValues type from " + currentDVType + " to " + dvType + " for field \"" + name + "\"");
            }
        }

        synchronized Set<String> getFieldNames() {
            return Set.copyOf(this.nameToNumber.keySet());
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.indexOptions.clear();
            this.docValuesType.clear();
            this.dimensions.clear();
            this.lowestUnassignedFieldNumber = -1;
        }
    }

    static final class FieldVectorProperties {
        final int numDimensions;
        final VectorEncoding vectorEncoding;
        final VectorSimilarityFunction similarityFunction;

        FieldVectorProperties(int numDimensions, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) {
            this.numDimensions = numDimensions;
            this.vectorEncoding = vectorEncoding;
            this.similarityFunction = similarityFunction;
        }
    }

    static final class FieldDimensions {
        public final int dimensionCount;
        public final int indexDimensionCount;
        public final int dimensionNumBytes;

        public FieldDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.indexDimensionCount = indexDimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }
    }
}

