/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.Codec;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnFieldVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentWriteState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Sorter;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IOContext;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.util.InfoStream;
import java.io.IOException;

class VectorValuesConsumer {
    private final Codec codec;
    private final Directory directory;
    private final SegmentInfo segmentInfo;
    private final InfoStream infoStream;
    private Accountable accountable = Accountable.NULL_ACCOUNTABLE;
    private KnnVectorsWriter writer;

    VectorValuesConsumer(Codec codec, Directory directory, SegmentInfo segmentInfo, InfoStream infoStream) {
        this.codec = codec;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.infoStream = infoStream;
    }

    private void initKnnVectorsWriter(String fieldName) throws IOException {
        if (this.writer == null) {
            KnnVectorsFormat fmt = this.codec.knnVectorsFormat();
            if (fmt == null) {
                throw new IllegalStateException("field=\"" + fieldName + "\" was indexed as vectors but codec does not support vectors");
            }
            SegmentWriteState initialWriteState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, null, null, IOContext.DEFAULT);
            this.writer = fmt.fieldsWriter(initialWriteState);
            this.accountable = this.writer;
        }
    }

    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        this.initKnnVectorsWriter(fieldInfo.name);
        return this.writer.addField(fieldInfo);
    }

    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush(state.segmentInfo.maxDoc(), sortMap);
            this.writer.finish();
        }
        catch (Throwable throwable) {
            IOUtils.close(this.writer);
            throw throwable;
        }
        IOUtils.close(this.writer);
    }

    void abort() {
        IOUtils.closeWhileHandlingException(this.writer);
    }

    public Accountable getAccountable() {
        return this.accountable;
    }
}

