/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.ConjunctionMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatches;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalsSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

abstract class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;

    protected ConjunctionIntervalsSource(List<IntervalsSource> subSources) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals);
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1);

    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public final IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        IntervalIterator it = this.combine(subs.stream().map(m4 -> IntervalMatches.wrapMatches(m4, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return this.createMatchesIterator(it, subs);
    }
}

