/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletMapping;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.SecurityHandler;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletSecurityAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServletSecurityAnnotationHandler.class);

    public ServletSecurityAnnotationHandler(WebAppContext wac) {
        super(false, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        List<ConstraintMapping> constraintMappings;
        SecurityHandler securityHandler = this._context.getSecurityHandler();
        if (!(securityHandler instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        ConstraintAware securityHandler2 = (ConstraintAware)((Object)securityHandler);
        ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
        if (servletSecurity == null) {
            return;
        }
        List<ServletMapping> servletMappings = this.getServletMappings(clazz.getCanonicalName());
        if (this.constraintsExist(servletMappings, constraintMappings = ((ConstraintAware)((Object)this._context.getSecurityHandler())).getConstraintMappings())) {
            LOG.warn("Constraints already defined for {}, skipping ServletSecurity annotation", (Object)clazz.getName());
            return;
        }
        constraintMappings = new ArrayList<ConstraintMapping>();
        ServletSecurityElement securityElement = new ServletSecurityElement(servletSecurity);
        for (ServletMapping sm : servletMappings) {
            for (String url : sm.getPathSpecs()) {
                this._context.getMetaData().setOrigin("constraint.url." + url, servletSecurity, clazz);
                constraintMappings.addAll(ConstraintSecurityHandler.createConstraintsWithMappingsForPath(clazz.getName(), url, securityElement));
            }
        }
        constraintMappings.forEach(securityHandler2::addConstraintMapping);
        securityHandler2.checkPathsWithUncoveredHttpMethods();
    }

    protected List<ServletMapping> getServletMappings(String className) {
        ServletMapping[] mappings;
        ArrayList<ServletMapping> results = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : mappings = this._context.getServletHandler().getServletMappings()) {
            ServletHolder holder = this._context.getServletHandler().getServlet(mapping.getServletName());
            if (holder.getClassName() == null || !holder.getClassName().equals(className)) continue;
            results.add(mapping);
        }
        return results;
    }

    protected boolean constraintsExist(List<ServletMapping> servletMappings, List<ConstraintMapping> constraintMappings) {
        boolean exists = false;
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs = mapping.getPathSpecs();
            if (pathSpecs == null) continue;
            block1: for (int i = 0; constraintMappings != null && i < constraintMappings.size() && !exists; ++i) {
                for (String pathSpec : pathSpecs) {
                    if (!pathSpec.equals(constraintMappings.get(i).getPathSpec())) continue;
                    exists = true;
                    continue block1;
                }
            }
        }
        return exists;
    }
}

