/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow.tracking.creds;

import com.dataiku.dss.shadelib.org.mlflow.tracking.creds.DatabricksHostCredsProvider;
import com.dataiku.dss.shadelib.org.mlflow.tracking.creds.DatabricksMlflowHostCreds;
import com.dataiku.dss.shadelib.org.mlflow.tracking.utils.DatabricksContext;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksDynamicHostCredsProvider
extends DatabricksHostCredsProvider {
    private static final Logger logger = LoggerFactory.getLogger(DatabricksDynamicHostCredsProvider.class);
    private final Map<String, String> configProvider;

    private DatabricksDynamicHostCredsProvider(Map<String, String> configProvider) {
        this.configProvider = configProvider;
    }

    public static DatabricksDynamicHostCredsProvider createIfAvailable() {
        return DatabricksDynamicHostCredsProvider.createIfAvailable("com.dataiku.dss.shadelib.com.databricks.config.DatabricksClientSettingsProvider");
    }

    @VisibleForTesting
    static DatabricksDynamicHostCredsProvider createIfAvailable(String className) {
        Map<String, String> configProvider = DatabricksContext.getConfigProviderIfAvailable(className);
        if (configProvider == null) {
            return null;
        }
        return new DatabricksDynamicHostCredsProvider(configProvider);
    }

    @Override
    public DatabricksMlflowHostCreds getHostCreds() {
        return new DatabricksMlflowHostCreds(this.configProvider.get("host"), this.configProvider.get("username"), this.configProvider.get("password"), this.configProvider.get("token"), "true".equals(this.configProvider.get("shouldIgnoreTlsVerification")));
    }

    @Override
    public void refresh() {
    }
}

