/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.compat;

import com.dataiku.dip.utils.ExceptionUtils;
import java.io.Serializable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.util.LongAccumulator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class package$ {
    public static package$ MODULE$;
    private final org.apache.spark.ml.linalg.Vectors$ MLVectors;
    private final DataType mlVectorType;

    static {
        new package$();
    }

    public Try<SQLContext> instantiateHiveContext(Map<String, String> hiveConfig, SparkContext sparkContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SQLContext c = (SQLContext)Class.forName("org.apache.spark.sql.hive.HiveContext").getDeclaredConstructor(SparkContext.class).newInstance(sparkContext);
            hiveConfig.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$instantiateHiveContext$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                package$.$anonfun$instantiateHiveContext$3(c, x$1);
                return BoxedUnit.UNIT;
            });
            return c;
        });
    }

    public boolean isHiveContext(SQLContext sqlContext) {
        boolean bl;
        block4: {
            if (sqlContext instanceof HiveContext) {
                return true;
            }
            try {
                Class sparkSessionClass = sqlContext.sparkSession().getClass();
                JavaUniverse.JavaMirror mirror = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(sparkSessionClass.getClassLoader());
                Symbols.ClassSymbolApi sparkSessionSymbol = mirror.classSymbol((Object)sparkSessionClass);
                Mirrors.InstanceMirror sparkSessionMirror = mirror.reflect((Object)sqlContext.sparkSession(), ClassTag$.MODULE$.apply(SparkSession.class));
                Symbols.SymbolApi sessionStateSymbol = sparkSessionSymbol.toType().member((Names.NameApi)((Names)scala.reflect.runtime.package$.MODULE$.universe()).TermName().apply("sessionState"));
                Boolean bl2 = sessionStateSymbol == null || !sessionStateSymbol.isMethod() ? BoxesRunTime.boxToBoolean((boolean)false) : BoxedUnit.UNIT;
                Object sessionState = sparkSessionMirror.reflectMethod(sessionStateSymbol.asMethod()).apply((Seq)Nil$.MODULE$);
                Mirrors.InstanceMirror sessionStateMirror = mirror.reflect(sessionState, ClassTag$.MODULE$.Any());
                Symbols.SymbolApi catalogSymbol = mirror.classSymbol(sessionState.getClass()).toType().member((Names.NameApi)((Names)scala.reflect.runtime.package$.MODULE$.universe()).TermName().apply("catalog"));
                Boolean bl3 = catalogSymbol == null || !catalogSymbol.isMethod() ? BoxesRunTime.boxToBoolean((boolean)false) : BoxedUnit.UNIT;
                Object catalog = sessionStateMirror.reflectMethod(catalogSymbol.asMethod()).apply((Seq)Nil$.MODULE$);
                if (catalog != null && catalog.getClass().getSimpleName().equals("HiveSessionCatalog")) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable t) {
                bl = false;
            }
        }
        return bl;
    }

    public Function1<Dataset<Row>, Object> isStreamingDf() {
        return (Function1 & Serializable & scala.Serializable)df -> BoxesRunTime.boxToBoolean((boolean)df.isStreaming());
    }

    public Dataset<Row> dataset2DataFrame(Dataset<?> ds) {
        return ds.toDF();
    }

    public Dataset<Row> getNativeReaderDataframe(DataFrameReader dataFrameReader, SQLContext sqlContext, Seq<String> paths) {
        Object object = sqlContext.sparkContext().version().compareTo("3.") >= 0 && new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.dku.use.recursiveFileLookup", "true"))).toBoolean() ? dataFrameReader.option("recursiveFileLookup", "true") : BoxedUnit.UNIT;
        return dataFrameReader.load(paths);
    }

    public SQLContext getSQLContextForSparklyr(SparkSession ssc) {
        return ssc.sqlContext();
    }

    public org.apache.spark.ml.linalg.Vectors$ MLVectors() {
        return this.MLVectors;
    }

    public DataType mlVectorType() {
        return this.mlVectorType;
    }

    public org.apache.spark.ml.linalg.Vector mllib2mlVector(Vector vector) {
        return vector.asML();
    }

    public Vector ml2mllibVector(org.apache.spark.ml.linalg.Vector vector) {
        org.apache.spark.ml.linalg.Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            return Vectors$.MODULE$.dense(denseVector.values());
        }
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            return Vectors$.MODULE$.sparse(sparseVector.size(), sparseVector.indices(), sparseVector.values());
        }
        throw new MatchError((Object)vector2);
    }

    public LabeledPoint mllib2mlLabeledPoint(org.apache.spark.mllib.regression.LabeledPoint lp) {
        return new LabeledPoint(lp.label(), this.mllib2mlVector(lp.features()));
    }

    public Column isNull(Column c) {
        return functions$.MODULE$.isnull(c);
    }

    public org.apache.spark.ml.linalg.Vector getLogitCoefficients(LogisticRegressionModel lrm) {
        return lrm.coefficients();
    }

    public org.apache.spark.ml.linalg.Vector getLinregCoefficients(LinearRegressionModel lrm) {
        return lrm.coefficients();
    }

    public Column dku_to_json(Column c) {
        return functions$.MODULE$.to_json(c);
    }

    public LongAccumulator makeLongAccumulator(String name, SparkContext sc) {
        return sc.longAccumulator(name);
    }

    public IndexedSeq<String> h2oNumericalFeatureVectorToNames(String featuresColumn, Integer nNumericVar) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(nNumericVar)).map((Function1 & Serializable & scala.Serializable)x$5 -> package$.$anonfun$h2oNumericalFeatureVectorToNames$1(featuresColumn, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public RDD<Row> toRDDWithSchema(Dataset<Row> df) {
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(df.schema());
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder resolvedEncoder = qual$1.resolveAndBind(x$1, x$2);
        return df.queryExecution().toRdd().map((Function1)resolvedEncoder.createDeserializer(), ClassTag$.MODULE$.apply(Row.class));
    }

    public Tuple2<Object, Object> offsetObjectsToOffsets(Option<Offset> start, Offset end) {
        int startOrdinal = (int)((LongOffset)start.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LongOffset(-1L))).offset() + 1;
        int endOrdinal = (int)((LongOffset)end).offset() + 1;
        return new Tuple2.mcII.sp(startOrdinal, endOrdinal);
    }

    public LongOffset commitOffsetToOffset(Offset end) {
        return (LongOffset)end;
    }

    public Tuple2<Map<String, String>, Map<String, String>> addGroupIdProperties(Properties props, Map<String, String> kafkaOptions, Map<String, String> sparkOptions) {
        if (props.containsKey("group.id")) {
            return new Tuple2((Object)kafkaOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kafka.group.id"), (Object)props.getProperty("group.id"))), sparkOptions);
        }
        if (props.containsKey("group.id.prefix")) {
            return new Tuple2(kafkaOptions, (Object)sparkOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupIdPrefix"), (Object)props.getProperty("group.id.prefix"))));
        }
        return new Tuple2(kafkaOptions, sparkOptions);
    }

    public static final /* synthetic */ boolean $anonfun$instantiateHiveContext$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$instantiateHiveContext$3(SQLContext c$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            try {
                c$1.setConf(k, v);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                Logger.getLogger((String)"dku.spark.hive").warn((Object)new StringBuilder(26).append("Unable to set property ").append(k).append(" : ").append(ExceptionUtils.getMessageWithCauses((Throwable)e)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$h2oNumericalFeatureVectorToNames$1(String featuresColumn$1, int x$5) {
        return new StringBuilder(1).append(featuresColumn$1).append(".").append(x$5).toString();
    }

    private package$() {
        MODULE$ = this;
        this.MLVectors = org.apache.spark.ml.linalg.Vectors$.MODULE$;
        this.mlVectorType = org.apache.spark.ml.dataiku.compat.package$.MODULE$.mlVectorType();
    }
}

