/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.filter;

import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class FilterDesc
implements Serializable {
    public static final String GREL_MODE = "CUSTOM";
    public static final String SQL_MODE = "SQL";
    public static final String ES_QUERY_STRING_MODE = "ES_QUERY_STRING";
    public static final String AST_AND_MODE = "&&";
    public static final String AST_OR_MODE = "||";
    public boolean distinct;
    @Nullable
    String expression;
    public boolean enabled;
    @Nullable
    @Deprecated
    public ExpressionLanguage language;
    @Nullable
    public FilterUiData uiData;
    @Nullable
    public transient VariablesContext expressionVariablesContext;

    public static boolean isAstMode(String mode) {
        return AST_AND_MODE.equals(mode) || AST_OR_MODE.equals(mode);
    }

    public ExpressionLanguage getExpressionLanguage() {
        if (this.language != null) {
            return this.language;
        }
        return this.uiData != null && this.uiData.mode != null && this.uiData.mode.equals(SQL_MODE) ? ExpressionLanguage.SQL : ExpressionLanguage.GREL;
    }

    public static FilterDesc grelFilter(String expression) {
        FilterDesc filter = new FilterDesc();
        filter.expression = expression;
        filter.enabled = true;
        filter.uiData = new FilterUiData();
        filter.uiData.mode = GREL_MODE;
        return filter;
    }

    public static FilterDesc andFilter(FilterDesc ... filters) {
        return FilterDesc.combineFilter(AST_AND_MODE, filters);
    }

    public static FilterDesc orFilter(FilterDesc ... filters) {
        return FilterDesc.combineFilter(AST_OR_MODE, filters);
    }

    private static FilterDesc combineFilter(String mode, FilterDesc ... filters) {
        if (filters.length == 0) {
            return null;
        }
        if (filters.length == 1) {
            return filters[0];
        }
        FilterDesc filter = new FilterDesc();
        filter.expression = null;
        filter.enabled = true;
        filter.uiData = new FilterUiData();
        filter.uiData.mode = mode;
        for (FilterDesc subFilter : filters) {
            FilterUiCondition condition = new FilterUiCondition();
            condition.subCondition = subFilter;
            filter.uiData.conditions.add(condition);
        }
        return filter;
    }

    public static enum ExpressionLanguage {
        GREL,
        SQL;

    }

    public static class FilterUiData
    implements Serializable {
        public String mode = "&&";
        public List<FilterUiCondition> conditions = Lists.newArrayList();
        @Nullable
        public RuleColor color;
    }

    public static class FilterUiCondition
    implements Serializable {
        public String input;
        public String operator;
        public String col;
        public String string;
        public double num;
        public double num2;
        public String date;
        public String time;
        public String date2;
        public String time2;
        public String unit;
        public List<FilterUiListConditionValue> items;
        public FilterDesc subCondition;
    }

    public static class RuleColor
    implements Serializable {
        public String styleClass;
        public String styleCustomFontColor;
        public String styleCustomBackgroundColor;
    }

    public static class FilterUiListConditionValue
    implements Serializable {
        public String string;
        public double num;
        public String date;
        public String time;
        public String unit;
    }

    public static enum FilterUiOperator {
        EMPTY_ARRAY("empty array"),
        NOT_EMPTY_ARRAY("not empty array"),
        CONTAINS_ARRAY("array contains"),
        NOT_CONTAINS_ARRAY("array not contains"),
        NOT_EMPTY("not empty"),
        EMPTY("is empty"),
        NOT_EMPTY_STRING("not empty string"),
        EMPTY_STRING("empty string"),
        IS_TRUE("true"),
        IS_FALSE("false"),
        EQUALS_STRING("== [string]"),
        EQUALS_CASE_INSENSITIVE_STRING("== [string]i"),
        NOT_EQUALS_STRING("!= [string]"),
        SAME("== [NaNcolumn]"),
        DIFFERENT("!= [NaNcolumn]"),
        EQUALS_NUMBER("== [number]"),
        NOT_EQUALS_NUMBER("!= [number]"),
        GREATER_NUMBER(">  [number]"),
        LESS_NUMBER("<  [number]"),
        GREATER_OR_EQUAL_NUMBER(">= [number]"),
        LESS_OR_EQUAL_NUMBER("<= [number]"),
        BETWEEN_NUMBER(">< [number]"),
        NOT_BETWEEN_NUMBER("<> [number]"),
        EQUALS_DATE("== [date]"),
        GREATER_DATE(">  [date]"),
        GREATER_OR_EQUAL_DATE(">= [date]"),
        LESS_DATE("<  [date]"),
        LESS_OR_EQUAL_DATE("<= [date]"),
        BETWEEN_DATE(">< [date]"),
        EQUALS_COL("== [column]"),
        NOT_EQUALS_COL("!= [column]"),
        GREATER_COL(">  [column]"),
        LESS_COL("<  [column]"),
        GREATER_OR_EQUAL_COL(">= [column]"),
        LESS_OR_EQUAL_COL("<= [column]"),
        CONTAINS_STRING("contains"),
        CONTAINS_CASE_INSENSITIVE_STRING("contains [string]i"),
        NOT_CONTAINS_STRING("not contains"),
        NOT_CONTAINS_CASE_INSENSITIVE_STRING("not contains [string]i"),
        REGEX("regex"),
        GEO_WITHIN("geoWithin"),
        GEO_CONTAINS("geoContains"),
        IN_ANY_OF_STRING("in [string]"),
        IN_NONE_OF_STRING("not in [string]"),
        IN_ANY_OF_NUMBER("in [number]"),
        IN_NONE_OF_NUMBER("not in [number]"),
        IN_ANY_OF_DATE("in [date]"),
        IN_NONE_OF_DATE("not in [date]"),
        IN_ANY_OF_ENUM("in [enum]"),
        IN_NONE_OF_ENUM("not in [enum]"),
        ARRAY_CONTAINS_ANY_ENUM("array contains any [enum]"),
        ARRAY_CONTAINS_NONE_ENUM("array contains none [enum]"),
        ARRAY_CONTAINS_ALL_ENUM("array contains all [enum]"),
        STATUS_NO_LONGER_HEALTHY("status no longer healthy"),
        STATUS_CHANGES("status changes"),
        STATUS_BECOMES_ANY_OF("status becomes any of");

        private final String repr;

        private FilterUiOperator(String repr) {
            this.repr = repr;
        }

        public static FilterUiOperator fromRepr(String repr) throws UnsupportedOperationException {
            for (FilterUiOperator value : FilterUiOperator.values()) {
                if (!value.repr.equals(repr)) continue;
                return value;
            }
            throw new UnsupportedOperationException("Unknown operator : " + repr);
        }

        public String getRepr() {
            return this.repr;
        }
    }
}

