/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.streamimpl;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StreamColumnFactory
implements ColumnFactory {
    private final Map<String, StreamColumn> nameToCol = new HashMap<String, StreamColumn>();
    private final String creationSite;
    private int currentStorageIndex = 0;
    private StreamColumn firstVisibleColumn;
    private StreamColumn lastVisibleColumn;
    private Iterable<Column> cachedColumns;
    private boolean complainedAboutMixedUpColumnFactories;
    public List<String> unknownInputColumnsBuffer = new ArrayList<String>();
    public boolean storeMessages = false;
    private static final DKULogger logger = DKULogger.getLogger(StreamColumnFactory.class);

    public StreamColumnFactory() {
        this.creationSite = this.takeShortStack();
    }

    public StreamColumnFactory(Schema schema) {
        this.creationSite = this.takeShortStack();
        for (SchemaColumn sc : schema.getColumns()) {
            this.column(sc.getName());
        }
    }

    private void ensureVisible(StreamColumn sc) {
        if (sc.visible) {
            return;
        }
        sc.visible = true;
        assert (sc.next == null);
        assert (sc.prev == null);
        if (this.lastVisibleColumn == null) {
            assert (this.firstVisibleColumn == null);
            this.lastVisibleColumn = sc;
            this.firstVisibleColumn = sc;
        } else {
            this.moveAfter(this.lastVisibleColumn, sc);
        }
        this.cachedColumns = null;
    }

    String takeShortStack() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(10L).map(val -> "      " + String.valueOf(val)).collect(Collectors.joining("\n"));
    }

    @VisibleForTesting
    synchronized void doNotComplainAboutMixedUpColumnFactories() {
        this.complainedAboutMixedUpColumnFactories = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complainAboutMixedUpColumnFactories(StreamColumn col) {
        if (this.complainedAboutMixedUpColumnFactories) {
            return;
        }
        StreamColumnFactory streamColumnFactory = this;
        synchronized (streamColumnFactory) {
            if (this.complainedAboutMixedUpColumnFactories) {
                return;
            }
            this.complainedAboutMixedUpColumnFactories = true;
        }
        String message = "Attempted to access column \"" + col.getName() + "\" using a different stream column factory: this might affect performance. \nRow's own column factory comes from:\n" + this.creationSite + "\nOther column factory from:\n" + col.columnFactory.creationSite + "\nIssue located:\n" + this.takeShortStack();
        logger.warn((Object)message);
    }

    private void moveAfter(StreamColumn before, StreamColumn col) {
        if (before == col) {
            return;
        }
        this.detach(col);
        if (before.next == null) {
            assert (before == this.lastVisibleColumn);
            this.lastVisibleColumn = col;
        } else {
            before.next.prev = col;
            col.next = before.next;
        }
        col.prev = before;
        before.next = col;
        this.cachedColumns = null;
    }

    private void moveBefore(StreamColumn after, StreamColumn col) {
        if (after == col) {
            return;
        }
        this.detach(col);
        if (after.prev == null) {
            assert (after == this.firstVisibleColumn);
            this.firstVisibleColumn = col;
        } else {
            after.prev.next = col;
            col.prev = after.prev;
        }
        col.next = after;
        after.prev = col;
        this.cachedColumns = null;
    }

    private void detach(StreamColumn col) {
        if (col == this.lastVisibleColumn) {
            this.lastVisibleColumn = col.prev;
        }
        if (col == this.firstVisibleColumn) {
            this.firstVisibleColumn = col.next;
        }
        if (col.prev != null) {
            col.prev.next = col.next;
        }
        if (col.next != null) {
            col.next.prev = col.prev;
        }
        col.prev = null;
        col.next = null;
        this.cachedColumns = null;
    }

    synchronized StreamColumn invisibleColumn(String name) {
        StreamColumn sc = this.nameToCol.get(name);
        if (sc != null) {
            return this.nameToCol.get(name);
        }
        sc = new StreamColumn();
        sc.name = name;
        sc.columnFactory = this;
        sc.storageIndex = this.currentStorageIndex++;
        this.nameToCol.put(name, sc);
        this.cachedColumns = null;
        return sc;
    }

    synchronized StreamColumn getColumnIncludingInvisible(String name) {
        return this.nameToCol.get(name);
    }

    @Override
    public synchronized StreamColumn getColumn(String name) {
        StreamColumn col = this.getColumnIncludingInvisible(name);
        if (col != null && col.visible) {
            return col;
        }
        return null;
    }

    @Override
    public synchronized StreamColumn column(String name) {
        StreamColumn sc = this.invisibleColumn(name);
        this.ensureVisible(sc);
        return sc;
    }

    @Override
    public synchronized Column column(String name, Processor.ProcessorRole role) {
        return this.column(name);
    }

    @Override
    public synchronized Column columnAfter(String before, String newCol) {
        StreamColumn col = this.getColumn(newCol);
        if (col != null) {
            return col;
        }
        col = this.column(newCol);
        StreamColumn beforeCol = this.getColumn(before);
        if (beforeCol != null) {
            this.moveAfter(beforeCol, col);
        }
        return col;
    }

    @Override
    public synchronized Column columnAfter(String before, String after, Processor.ProcessorRole role) {
        return this.columnAfter(before, after);
    }

    @Override
    public synchronized Column columnBefore(String after, String newCol) {
        StreamColumn col = this.getColumn(newCol);
        if (col != null) {
            return col;
        }
        col = this.column(newCol);
        StreamColumn afterCol = this.getColumn(after);
        if (afterCol != null) {
            this.moveBefore(afterCol, col);
        }
        return col;
    }

    @Override
    public synchronized Column columnBefore(String after, String newCol, Processor.ProcessorRole role) {
        return this.columnBefore(after, newCol);
    }

    @Override
    public synchronized Column getColumnAfter(String current) {
        StreamColumn sc = this.getColumn(current);
        if (sc != null) {
            return sc.next;
        }
        return null;
    }

    @Override
    public synchronized void deleteColumn(String name) {
    }

    @Override
    public synchronized void moveAtStart(String name) {
        StreamColumn sc = this.getColumn(name);
        if (sc != null && this.firstVisibleColumn != null) {
            this.moveBefore(this.firstVisibleColumn, sc);
        }
    }

    @Override
    public synchronized void moveAtEnd(String name) {
        StreamColumn sc = this.getColumn(name);
        if (sc != null && this.lastVisibleColumn != null) {
            this.moveAfter(this.lastVisibleColumn, sc);
        }
    }

    @Override
    public synchronized void moveBefore(String after, String name) {
        StreamColumn afterCol = this.getColumn(after);
        StreamColumn nameCol = this.getColumn(name);
        if (afterCol != null && nameCol != null) {
            this.moveBefore(afterCol, nameCol);
        }
    }

    @Override
    public synchronized void moveAfter(String before, String name) {
        StreamColumn beforeCol = this.getColumn(before);
        StreamColumn nameCol = this.getColumn(name);
        if (beforeCol != null && nameCol != null) {
            this.moveAfter(beforeCol, nameCol);
        }
    }

    List<Column> columnsIncludingInvisible() {
        return Lists.newArrayList(this.nameToCol.values());
    }

    @Override
    public synchronized Iterable<Column> columns() {
        if (this.cachedColumns != null) {
            return this.cachedColumns;
        }
        ArrayList<StreamColumn> out = new ArrayList<StreamColumn>(this.nameToCol.size());
        StreamColumn sc = this.firstVisibleColumn;
        while (sc != null) {
            out.add(sc);
            sc = sc.next;
        }
        this.cachedColumns = Iterables.unmodifiableIterable(out);
        return this.cachedColumns;
    }

    synchronized void renameColumn(StreamColumn streamColumn, String newName) {
        assert (streamColumn.visible);
        if (Objects.equals(newName, streamColumn.name)) {
            return;
        }
        StreamColumn overriddenColumn = this.nameToCol.get(newName);
        if (overriddenColumn != null && overriddenColumn.visible) {
            this.detach(overriddenColumn);
            this.nameToCol.remove(newName);
        }
        this.nameToCol.remove(streamColumn.name);
        streamColumn.name = newName;
        this.nameToCol.put(newName, streamColumn);
        this.cachedColumns = null;
    }

    public synchronized List<String> getUnknownInputColumnBuffer() {
        return this.unknownInputColumnsBuffer;
    }
}

