/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ColoringDefinition
implements Serializable {
    public static ColoringGroup findAppliedColoringGroup(List<ColoringGroup> coloringGroups, String columnName) {
        for (int i = coloringGroups.size() - 1; i >= 0; --i) {
            ColoringGroup coloringGroup = coloringGroups.get(i);
            if (!coloringGroup.enabled) continue;
            if (coloringGroup.scope == ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN) {
                return coloringGroup;
            }
            if (coloringGroup.scope != ColoringGroupScope.COLUMNS) continue;
            boolean isTargeted = coloringGroup.targetedColumnNames.stream().anyMatch(columnName::equals);
            if (!isTargeted) continue;
            return coloringGroup;
        }
        return null;
    }

    @UIModel
    public static class ColoringGroup
    implements Serializable {
        public ColoringGroupScope scope;
        public ColoringGroupScheme scheme;
        public boolean enabled;
        @UINullable
        public String basedOnColumnName;
        public List<String> targetedColumnNames;
        public RulesGroup rulesGroup;
        @UINullable
        public ColorScaleDef colorScaleDef = null;

        public ColoringGroup(ColoringGroupScope scope, ColoringGroupScheme scheme, boolean enabled, String basedOnColumnName, List<String> targetedColumnNames) {
            this.scope = Objects.requireNonNullElse(scope, ColoringGroupScope.COLUMNS);
            this.scheme = Objects.requireNonNullElse(scheme, ColoringGroupScheme.MEANING_AND_STATUS);
            this.enabled = enabled;
            this.basedOnColumnName = basedOnColumnName;
            this.targetedColumnNames = Objects.requireNonNullElseGet(targetedColumnNames, ArrayList::new);
            this.rulesGroup = new RulesGroup();
            if (this.scope == ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN || this.scheme == ColoringGroupScheme.COLOR_SCALE) {
                this.colorScaleDef = new ColorScaleDef();
            }
        }

        public ColoringGroup(ColoringGroupScope scope, ColoringGroupScheme scheme, boolean enabled, List<String> targetedColumnNames) {
            this(scope, scheme, enabled, null, targetedColumnNames);
        }

        public ColoringGroup(ColoringGroupScope scope, ColoringGroupScheme scheme, boolean enabled, String basedOnColumnName) {
            this(scope, scheme, enabled, basedOnColumnName, null);
        }

        public ColoringGroup() {
            this(null, null, true, null, null);
        }

        public boolean isBasedOnTargetedColumn(String targetedColumnName) {
            return this.scope == ColoringGroupScope.COLUMNS || this.scope == ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN && targetedColumnName.equals(this.basedOnColumnName);
        }

        public boolean isBasedOnAnotherColumn(String targetedColumnName) {
            return this.scope == ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN && !targetedColumnName.equals(this.basedOnColumnName);
        }
    }

    @UIModel
    public static enum ColoringGroupScope {
        COLUMNS,
        ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN;

    }

    @UIModel
    public static enum ColoringGroupScheme {
        MEANING_AND_STATUS,
        COLOR_SCALE,
        RULES;

    }

    public static class RulesGroup
    implements Serializable {
        public List<FilterDesc> filterDescs = new ArrayList<FilterDesc>();

        public RulesGroup(List<FilterDesc> filterDescs) {
            this.filterDescs = filterDescs;
        }

        public RulesGroup() {
        }

        public List<FilterDesc> getBasedOnColumnFilterDescs(String columnName) {
            return this.filterDescs.stream().map(filterDesc -> {
                FilterDesc basedOnColumnfilterDesc = (FilterDesc)JSON.deepCopy((Object)filterDesc);
                if (basedOnColumnfilterDesc.uiData != null) {
                    for (FilterDesc.FilterUiCondition condition : basedOnColumnfilterDesc.uiData.conditions) {
                        condition.input = columnName;
                    }
                }
                return basedOnColumnfilterDesc;
            }).collect(Collectors.toList());
        }
    }

    public static class ColorScaleDef
    implements Serializable {
        public String colorPalette;
        public Palette customPalette = new Palette();
        public double max = -1.0;
        public double min = 0.0;
        public String paletteType;
        public String quantizationMode;
        public List<String> sample = new ArrayList<String>();
        public boolean useSample2 = false;
    }

    public static class Palette
    implements Serializable {
        public String id = "__dku_custom__";
        public String name = "Custom palette";
        public List<String> colors = new ArrayList<String>();
        public List<Double> values = new ArrayList<Double>();
        public boolean fixedValues = false;
    }

    @UIModel
    public static class ColumnRules
    implements Serializable {
        public String column;
        public List<FilterDesc> rulesDesc;

        public ColumnRules(String column, List<FilterDesc> rulesDesc) {
            this.column = column;
            this.rulesDesc = rulesDesc;
        }
    }

    @UIModel
    public static enum ValueColoringMode {
        HASH,
        RANK;

    }

    @UIModel
    public static enum TableColoringScheme {
        MEANING_AND_STATUS,
        FILL_ONLY,
        INDIVIDUAL_COLUMNS_VALUES,
        INDIVIDUAL_COLUMNS_RULES,
        ALL_COLUMNS_VALUES,
        SINGLE_COLUMN_VALUES,
        SINGLE_COLUMN_RULES,
        SINGLE_VALUE_HIGHLIGHT,
        COLORING_GROUPS;

    }
}

