/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.utils.SingleCallAsserter;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamOutputWriter
extends OutputWriter {
    private OutputStream os;
    private OutputFormatter formatter;
    private boolean headerEmitted;
    private ColumnFactory cf;
    private SingleCallAsserter lre = new SingleCallAsserter();

    public OutputStreamOutputWriter(OutputStream os, OutputFormatter formatter) {
        this.os = os;
        this.formatter = formatter;
    }

    @Override
    public void init(ColumnFactory cf) throws IOException {
        this.cf = cf;
    }

    @Override
    public void emitRow(Row row) throws Exception {
        if (!this.headerEmitted) {
            this.formatter.header(this.cf, this.os);
            this.headerEmitted = true;
        }
        this.formatter.format(row, this.cf, this.os);
    }

    @Override
    public void lastRowEmitted() throws Exception {
        this.lre.call("processor already closed");
        this.formatter.footer(this.cf, this.os);
    }

    @Override
    public void cancel() throws Exception {
        this.lre.call("processor already closed");
        this.formatter.cancel(this.os);
    }

    @Override
    public long writtenBytes() throws IOException {
        return -1L;
    }
}

