/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontUtils {
    private static final Logger logger = LoggerFactory.getLogger(FontUtils.class);
    private static final Map<String, FontMetrics> fontMetrics = new HashMap<String, FontMetrics>();
    private static final Map<String, PDFont> defaultFonts = new HashMap<String, PDFont>();

    private FontUtils() {
    }

    public static final PDType0Font loadFont(PDDocument document, String fontPath) {
        try {
            return PDType0Font.load((PDDocument)document, (InputStream)FontUtils.class.getClassLoader().getResourceAsStream(fontPath));
        }
        catch (IOException e) {
            logger.warn("Cannot load given external font", (Throwable)e);
            return null;
        }
    }

    public static float getStringWidth(PDFont font, String text, float fontSize) {
        try {
            return font.getStringWidth(text) / 1000.0f * fontSize;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to determine text width", e);
        }
    }

    public static float getAscent(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            FontUtils.createFontMetrics(font);
        }
        return fontMetrics.get(fontName).ascent * fontSize;
    }

    public static float getDescent(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            FontUtils.createFontMetrics(font);
        }
        return fontMetrics.get(fontName).descent * fontSize;
    }

    public static float getHeight(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            FontUtils.createFontMetrics(font);
        }
        return fontMetrics.get(fontName).height * fontSize;
    }

    private static void createFontMetrics(PDFont font) {
        float base = font.getFontDescriptor().getXHeight() / 1000.0f;
        float ascent = font.getFontDescriptor().getAscent() / 1000.0f - base;
        float descent = font.getFontDescriptor().getDescent() / 1000.0f;
        fontMetrics.put(font.getName(), new FontMetrics(base + ascent - descent, ascent, descent));
    }

    public static void addDefaultFonts(PDFont font, PDFont fontBold, PDFont fontItalic, PDFont fontBoldItalic) {
        defaultFonts.put("font", font);
        defaultFonts.put("fontBold", fontBold);
        defaultFonts.put("fontItalic", fontItalic);
        defaultFonts.put("fontBoldItalic", fontBoldItalic);
    }

    public static Map<String, PDFont> getDefaultfonts() {
        return defaultFonts;
    }

    public static void setSansFontsAsDefault(PDDocument document) {
        defaultFonts.put("font", (PDFont)FontUtils.loadFont(document, "fonts/FreeSans.ttf"));
        defaultFonts.put("fontBold", (PDFont)FontUtils.loadFont(document, "fonts/FreeSansBold.ttf"));
        defaultFonts.put("fontItalic", (PDFont)FontUtils.loadFont(document, "fonts/FreeSansOblique.ttf"));
        defaultFonts.put("fontBoldItalic", (PDFont)FontUtils.loadFont(document, "fonts/FreeSansBoldOblique.ttf"));
    }

    private static final class FontMetrics {
        private final float ascent;
        private final float descent;
        private final float height;

        public FontMetrics(float height, float ascent, float descent) {
            this.height = height;
            this.ascent = ascent;
            this.descent = descent;
        }
    }
}

