/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.activity;

import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.services.CloudStacksCloud;
import com.dataiku.dip.server.services.DeploymentMode;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.blueprints.HookPhase;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPathStatus;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;

public class UsageSummaryModel {

    public static class DBTablesReport {
        public Map<String, Long> countByTable = new HashMap<String, Long>();
    }

    public static class HistoryReport {
        public Map<ActionType, Long> actionsByType = new HashMap<ActionType, Long>();
    }

    public static class AllArtifactsReport
    extends ArtifactsStats {
    }

    public static class CustomBlueprintsReport {
        public int nbBlueprints;
        public SingleSourceBlueprintVersionsStats blueprintVersions = new SingleSourceBlueprintVersionsStats();
        public ArtifactsStats artifacts = new ArtifactsStats();
    }

    public static class GovernModelVersionsReport
    extends AbstractGovernLayerReport {
        public SimpleStats governModelVersionsByModel;
    }

    public static class GovernModelsReport
    extends AbstractGovernLayerReport {
        public SimpleStats governModelsByProject;
    }

    public static class GovernBundlesReport
    extends AbstractGovernLayerReport {
        public SimpleStats governBundlesByProject;
    }

    public static class GovernProjectsReport
    extends AbstractGovernLayerReport {
        public SimpleStats dkuProjectsByGovernProject;
    }

    public static class BusinessInitiativesReport
    extends AbstractGovernLayerReport {
    }

    public static abstract class AbstractGovernLayerReport {
        public BlueprintVersionStatus standardBlueprintVersionStatus;
        public SingleSourceBlueprintVersionsStats customBlueprintVersions = new SingleSourceBlueprintVersionsStats();
        public ArtifactsStats artifacts = new ArtifactsStats();
        public Map<IdentifiersUtils.ItemSource, Integer> nbArtifactsBySource = new HashMap<IdentifiersUtils.ItemSource, Integer>();
    }

    public static class DkuProjectDeployerDeploymentsReport
    extends AbstractDkuLayerReport {
        public int nbProjectDeployerDeployments;
    }

    public static class DkuProjectDeployerInfrasReport
    extends AbstractDkuLayerReport {
        public int nbProjectDeployerInfras;
        public SimpleStats projectDeployerDeploymentsByInfra;
    }

    public static class DkuAPIDeployerDeploymentsReport
    extends AbstractDkuLayerReport {
        public int nbAPIDeployerDeployments;
    }

    public static class DkuAPIDeployerInfrasReport
    extends AbstractDkuLayerReport {
        public int nbAPIDeployerInfras;
        public SimpleStats apiDeployerDeploymentsByInfra;
    }

    public static class DkuRetrievableKnowledgesReport
    extends AbstractDkuLayerReport {
        public int nbRetrievableKnowledges;
    }

    public static class DkuSavedModelVersionsReport
    extends AbstractDkuLayerReport {
        public int nbSavedModelVersions;
        public Map<String, Integer> savedModelVersionsByBPV = new HashMap<String, Integer>();
    }

    public static class DkuSavedModelsReport
    extends AbstractDkuLayerReport {
        public int nbSavedModels;
        public SimpleStats modelVersionsByModel;
        public SimpleStats governedModelVersionsByModel;
    }

    public static class DkuBundlesReport
    extends AbstractDkuLayerReport {
        public int nbBundles;
    }

    public static class DkuDatasetsReport
    extends AbstractDkuLayerReport {
        public int nbDatasets;
    }

    public static class DkuProjectsReport
    extends AbstractDkuLayerReport {
        public int nbDistinctNodeIds;
        public int nbProjects;
        public int nbGovernedProjects;
        public SimpleStats datasetsByProject;
        public SimpleStats bundlesByProject;
        public SimpleStats governedBundlesByProject;
        public SimpleStats modelsByProject;
        public SimpleStats governedModelsByProject;
        public SimpleStats retrievableKnowledgesByProject;
    }

    public static abstract class AbstractDkuLayerReport {
        public ArtifactsStats artifacts = new ArtifactsStats();
    }

    public static class SingleSourceBlueprintVersionsStats {
        public int nbBlueprintVersions;
        public Map<BlueprintVersionStatus, Integer> blueprintVersionsByStatus = new HashMap<BlueprintVersionStatus, Integer>();
        public SimpleStats nbWorkflowSteps;
        public SimpleStats nbConditionalWorkflowSteps;
        public SimpleStats nbSignoffConfigs;
        public SimpleStats feedbackGroupsBySignoffConfig;
        public SimpleStats nbRecurrentSignoffConfigs;
        public SimpleStats nbFields;
        public Map<FieldType, SimpleStats> fieldsByType = new HashMap<FieldType, SimpleStats>();
        public Map<SourceType, SimpleStats> referenceFieldsBySource = new HashMap<SourceType, SimpleStats>();
        public SimpleStats nbHooks;
        public Map<HookPhase, SimpleStats> hooksByPhase = new HashMap<HookPhase, SimpleStats>();
        public SimpleStats nbViews;
        public SimpleStats viewComponentsByView;
    }

    public static class ArtifactsStats {
        public int nbArtifacts;
        public int nbArchivedArtifacts;
        public SimpleStats filledFieldsByArtifact;
        public SimpleStats referenceAttachmentsByArtifact;
        public SimpleStats uploadedFilesAttachmentsByArtifact;
        public SimpleStats signoffsByArtifact;
        public Map<Signoff.SignoffStatus, SimpleStats> signoffsByArtifactByStatus = new HashMap<Signoff.SignoffStatus, SimpleStats>();
        public SimpleStats cycleIndexByArtifactBySignoff;
        public SimpleStats feedbackCountByArtifactBySignoff;
        public SimpleStats recurrentSignoffsByArtifactBySignoff;
    }

    public static class CustomPagesReport {
        public int nbPages;
        public Map<IdentifiersUtils.ItemSource, Integer> pagesBySource = new HashMap<IdentifiersUtils.ItemSource, Integer>();
        public int nbVisiblePages;
        public Map<String, Integer> pagesByType = new HashMap<String, Integer>();
    }

    public static class MigrationPathsReport {
        public int nbMigrationPaths;
        public Map<BlueprintVersionMigrationPathStatus, Integer> migrationPathsByStatus = new HashMap<BlueprintVersionMigrationPathStatus, Integer>();
        public Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Integer>>>> migrationPathsbyFromToSources = new HashMap<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Integer>>>>();
    }

    public static class BlueprintsReport {
        public int nbBlueprints;
        public Map<IdentifiersUtils.ItemSource, Integer> blueprintsBySource = new HashMap<IdentifiersUtils.ItemSource, Integer>();
        public int nbBlueprintVersions;
        public Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Integer>> blueprintVersionsBySource = new HashMap<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, Integer>>();
        public Map<BlueprintVersionStatus, Integer> blueprintVersionsByStatus = new HashMap<BlueprintVersionStatus, Integer>();
        public Map<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, SimpleStats>> blueprintVersionsByBlueprintBySource = new HashMap<IdentifiersUtils.ItemSource, Map<IdentifiersUtils.ItemSource, SimpleStats>>();
        public Map<BlueprintVersionStatus, SimpleStats> blueprintVersionsByBlueprintByStatus = new HashMap<BlueprintVersionStatus, SimpleStats>();
    }

    public static class PythonCodeEnvsSummaryReport {
        public String baseEnvVersion;
    }

    public static class ApiKeyReport {
        public int globalScopeApiKeysWithGroupsCount;
        public int globalScopeApiKeysWithoutGroupsCount;
    }

    public static class UserDetailedReport {
        public Map<UserSourceType, Long> byType = new HashMap<UserSourceType, Long>();

        public UserDetailedReport() {
            for (UserSourceType type : UserSourceType.values()) {
                this.byType.put(type, 0L);
            }
        }

        public void inc(UserSourceType type) {
            this.byType.put(type, this.byType.get(type) + 1L);
        }
    }

    public static class LicensingProfilesDetailedReport {
        public Map<String, List<String>> disabledByLogin = new HashMap<String, List<String>>();
        public Map<String, List<String>> byLogin = new HashMap<String, List<String>>();
    }

    @UIModel
    public static class SummaryReport {
        public int reportVersion = 4;
        public LimitsStatusComputer.LicenseLimitsStatus licenseLimits;
        public LicensingProfilesDetailedReport licenseProfileDetails = new LicensingProfilesDetailedReport();
        public UserDetailedReport userDetailedReport = new UserDetailedReport();
        public Map<String, Long> userActivity = new HashMap<String, Long>();
        public ApplicationConfigurator.DSSNodeType nodeType;
        public DeploymentMode deploymentMode;
        public CloudStacksCloud cloudStacksCloud;
        public ApiKeyReport apiKeys = new ApiKeyReport();
        public GeneralSettingsSummaryReport generalSettings = new GeneralSettingsSummaryReport();
        public PythonCodeEnvsSummaryReport pythonCodeEnvs = new PythonCodeEnvsSummaryReport();
        public String governPostgresVersion;
        public BlueprintsReport governBlueprints = new BlueprintsReport();
        public MigrationPathsReport governMigrationPaths = new MigrationPathsReport();
        public CustomPagesReport governCustomPages = new CustomPagesReport();
        public AllArtifactsReport governAllArtifacts = new AllArtifactsReport();
        public DkuProjectsReport governDkuProjects = new DkuProjectsReport();
        public DkuDatasetsReport governDkuDatasets = new DkuDatasetsReport();
        public DkuBundlesReport governDkuBundles = new DkuBundlesReport();
        public DkuSavedModelsReport governDkuSavedModels = new DkuSavedModelsReport();
        public DkuSavedModelVersionsReport governDkuSavedModelVersions = new DkuSavedModelVersionsReport();
        public DkuRetrievableKnowledgesReport governDkuRetrievableKnowledges = new DkuRetrievableKnowledgesReport();
        public DkuAPIDeployerInfrasReport governDkuAPIDeployerInfras = new DkuAPIDeployerInfrasReport();
        public DkuAPIDeployerDeploymentsReport governDkuAPIDeployerDeployments = new DkuAPIDeployerDeploymentsReport();
        public DkuProjectDeployerInfrasReport governDkuProjectDeployerInfras = new DkuProjectDeployerInfrasReport();
        public DkuProjectDeployerDeploymentsReport governDkuProjectDeployerDeployments = new DkuProjectDeployerDeploymentsReport();
        public BusinessInitiativesReport governBusinessInitiatives = new BusinessInitiativesReport();
        public GovernProjectsReport governGovernProjects = new GovernProjectsReport();
        public GovernBundlesReport governGovernBundles = new GovernBundlesReport();
        public GovernModelsReport governGovernModels = new GovernModelsReport();
        public GovernModelVersionsReport governGovernModelVersions = new GovernModelVersionsReport();
        public CustomBlueprintsReport governCustomBlueprints = new CustomBlueprintsReport();
        public HistoryReport governHistory = new HistoryReport();
        public DBTablesReport governDBTables = new DBTablesReport();
    }

    @UIModel
    public static class MonitoringReport {
        public BlueprintsReport governBlueprints = new BlueprintsReport();
        public MigrationPathsReport governMigrationPaths = new MigrationPathsReport();
        public CustomPagesReport governCustomPages = new CustomPagesReport();
        public AllArtifactsReport governAllArtifacts = new AllArtifactsReport();
        public DkuProjectsReport governDkuProjects = new DkuProjectsReport();
        public DkuDatasetsReport governDkuDatasets = new DkuDatasetsReport();
        public DkuBundlesReport governDkuBundles = new DkuBundlesReport();
        public DkuSavedModelsReport governDkuSavedModels = new DkuSavedModelsReport();
        public DkuSavedModelVersionsReport governDkuSavedModelVersions = new DkuSavedModelVersionsReport();
        public DkuRetrievableKnowledgesReport governDkuRetrievableKnowledges = new DkuRetrievableKnowledgesReport();
        public DkuAPIDeployerInfrasReport governDkuAPIDeployerInfras = new DkuAPIDeployerInfrasReport();
        public DkuAPIDeployerDeploymentsReport governDkuAPIDeployerDeployments = new DkuAPIDeployerDeploymentsReport();
        public DkuProjectDeployerInfrasReport governDkuProjectDeployerInfras = new DkuProjectDeployerInfrasReport();
        public DkuProjectDeployerDeploymentsReport governDkuProjectDeployerDeployments = new DkuProjectDeployerDeploymentsReport();
        public BusinessInitiativesReport governBusinessInitiatives = new BusinessInitiativesReport();
        public GovernProjectsReport governGovernProjects = new GovernProjectsReport();
        public GovernBundlesReport governGovernBundles = new GovernBundlesReport();
        public GovernModelsReport governGovernModels = new GovernModelsReport();
        public GovernModelVersionsReport governGovernModelVersions = new GovernModelVersionsReport();
        public CustomBlueprintsReport governCustomBlueprints = new CustomBlueprintsReport();
        public HistoryReport governHistory = new HistoryReport();
        public DBTablesReport governDBTables = new DBTablesReport();
    }

    public static class GeneralSettingsSummaryReport {
        public boolean sso;
        public SSOSettings.SSOProtocol ssoProtocol;
        public boolean ssoProvisioningEnabled;
        public boolean ldap;
        public boolean ldapAuthEnabled;
        public boolean ldapProvisioningEnabled;
        public boolean azureADSupplierEnabled;
        public boolean azureADProvisioningEnabled;
        public boolean pamAuthenticatorEnabled;
        public boolean customAuthenticatorEnabled;
        public boolean customUserSupplierEnabled;
        public boolean hashApiKeys;
        public int apiKeysLifetimeDays;
        public boolean enrichDSSUserFromLdapEnabled;
        public boolean hasDSSURL;
        public boolean hasAdminContact;
        public boolean graphite;
    }

    public static class SimpleStats {
        public int min = Integer.MAX_VALUE;
        public int max = -2147483647;
        public int sum = 0;
        public double median;
        public double mean;
        transient PSquarePercentile medianPSQuare = new PSquarePercentile(50.0);

        public void addValue(int value) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.sum += value;
            this.medianPSQuare.increment((double)value);
            this.median = this.medianPSQuare.getResult();
            this.mean = (double)this.sum / (double)this.medianPSQuare.getN();
        }
    }
}

