/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.context;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.utils.GHNewWriteTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=1)
public class GovernActionContextAspect {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.internal.history.aspect");

    @Around(value="execution(* *(..)) && @annotation(requestMapping)", argNames="pjp,requestMapping")
    public Object onRequestMapping(ProceedingJoinPoint pjp, RequestMapping requestMapping) throws Throwable {
        GovernAction governAction = ((MethodSignature)pjp.getSignature()).getMethod().getAnnotation(GovernAction.class);
        ActionType actionType = governAction != null ? governAction.value() : ActionType.UNKNOWN;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            AuthCtxUsage authCtxUsage = this.authService.getWithContextFromAnyOrNullNoXSRF(request);
            authCtx = authCtxUsage == null ? null : authCtxUsage.getAuthCtx();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to trace Govern action info: ", (Throwable)e);
        }
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachNewContext(actionType, authCtx);){
            Object object = pjp.proceed();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..)) && @annotation(ghWriteTransaction)", argNames="pjp,ghWriteTransaction")
    public Object onWriteTransaction(ProceedingJoinPoint pjp, GHWriteTransaction ghWriteTransaction) throws Throwable {
        boolean newTransaction = false;
        GovernActionContext.ContextContainer context = GovernActionContext.getContext();
        if (context.transactionStart == null) {
            newTransaction = true;
            context.transactionStart = OffsetDateTime.now();
        }
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            if (newTransaction) {
                context.transactionStart = null;
            }
        }
    }

    @Around(value="execution(* *(..)) && @annotation(ghNewWriteTransaction)", argNames="pjp,ghNewWriteTransaction")
    public Object onNewWriteTransaction(ProceedingJoinPoint pjp, GHNewWriteTransaction ghNewWriteTransaction) throws Throwable {
        GovernActionContext.ContextContainer previousContextContainer = GovernActionContext.removeContext();
        try {
            GovernActionContext.ContextContainer newContext = GovernActionContext.attachNewContext(previousContextContainer.actionType, previousContextContainer.authCtx);
            try {
                newContext.transactionStart = OffsetDateTime.now();
                Object object = pjp.proceed();
                if (newContext != null) {
                    newContext.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (newContext != null) {
                    try {
                        newContext.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            GovernActionContext.attachContext(previousContextContainer);
        }
    }
}

