/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import org.apache.commons.lang.math.NumberUtils;

public class MigrationJsonUtils {
    public static Optional<JsonObject> getObjectSubpath(JsonElement element, String ... path) {
        return MigrationJsonUtils.getSubpath(element, path).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
    }

    public static Optional<JsonArray> getArraySubpath(JsonElement element, String ... path) {
        return MigrationJsonUtils.getSubpath(element, path).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray);
    }

    public static Optional<String> getStringSubpath(JsonElement element, String ... path) {
        return MigrationJsonUtils.getSubpath(element, path).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString);
    }

    public static boolean getUnboxedBooleanSubpath(JsonElement element, boolean defaultIfNull, String ... path) {
        return MigrationJsonUtils.getSubpath(element, path).filter(JsonElement::isJsonPrimitive).filter(p -> p.getAsJsonPrimitive().isBoolean()).map(JsonElement::getAsBoolean).orElse(defaultIfNull);
    }

    public static Optional<Long> getLongSubpath(JsonElement element, String ... path) {
        return MigrationJsonUtils.getSubpath(element, path).filter(JsonElement::isJsonPrimitive).filter(primitiveElement -> NumberUtils.isNumber((String)primitiveElement.getAsString())).map(JsonElement::getAsLong);
    }

    public static Optional<JsonElement> getSubpath(JsonElement element, String ... path) {
        Optional<JsonElement> oElement = Optional.ofNullable(element);
        for (String subPath : path) {
            oElement = oElement.filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(o -> o.get(subPath));
        }
        return oElement;
    }
}

