/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.time_series;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.models.time_series.TimeSeriesHead;
import com.dataiku.gh.core.services.time_series.ITimeSeriesDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesDAO;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesHeadDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesDataService
implements ITimeSeriesDataService {
    @Autowired
    private ITimeSeriesDAO timeSeriesDAO;
    @Autowired
    private ITimeSeriesHeadDAO timeSeriesHeadDAO;

    @Override
    @GHWriteTransaction
    public String create(String owner, Set<TimeSeriesDatapoint> timeSeriesDatapoints) throws IOException {
        timeSeriesDatapoints.forEach(dp -> {
            if (StringUtils.isNotEmpty((CharSequence)dp.timeSeriesId)) {
                throw new ValidationException("Time-series ID `" + dp.timeSeriesId + "` can't be set in creation");
            }
        });
        String id = IdentifiersUtils.buildTimeSeriesId(this.timeSeriesHeadDAO.newId());
        TimeSeriesHead tsHead = TimeSeriesHead.build(id, owner);
        this.timeSeriesHeadDAO.create(tsHead);
        timeSeriesDatapoints.forEach(dp -> {
            dp.timeSeriesId = id;
        });
        this.push(timeSeriesDatapoints, false);
        return id;
    }

    @Override
    @GHReadonlyTransaction
    public TimeSeriesHead getHead(String timeSeriesId) throws IOException {
        return this.timeSeriesHeadDAO.get(timeSeriesId);
    }

    @Override
    @GHWriteTransaction
    public void push(Set<TimeSeriesDatapoint> timeSeriesDatapoints, boolean upsert) throws IOException {
        for (TimeSeriesDatapoint timeSeriesDataPoint : timeSeriesDatapoints) {
            if (!IdentifiersUtils.isValidTimeSeriesId(timeSeriesDataPoint.timeSeriesId)) {
                throw new ValidationException("Invalid Time Series ID: " + timeSeriesDataPoint.timeSeriesId);
            }
            if (!this.timeSeriesHeadDAO.exists(timeSeriesDataPoint.timeSeriesId)) {
                throw new NotFoundException("TimeSeries does not exists: " + timeSeriesDataPoint.timeSeriesId);
            }
            if (timeSeriesDataPoint.timestamp == 0L) {
                throw new ValidationException("Invalid timestamp: " + timeSeriesDataPoint.timestamp + " for timeSeries: " + timeSeriesDataPoint.timeSeriesId);
            }
            if (timeSeriesDataPoint.value != null) continue;
            throw new ValidationException("Null value for timeSeries: " + timeSeriesDataPoint.timeSeriesId);
        }
        this.timeSeriesDAO.push(timeSeriesDatapoints, upsert);
    }

    @Override
    @GHReadonlyTransaction
    public List<TimeSeriesDatapoint> get(String timeSeriesId, @Nullable Long timestampMin, @Nullable Long timestampMax) throws IOException {
        return this.timeSeriesDAO.list(timeSeriesId, timestampMin == null ? null : Instant.ofEpochMilli(timestampMin), timestampMax == null ? null : Instant.ofEpochMilli(timestampMax));
    }

    @Override
    @GHWriteTransaction
    public void delete(String timeSeriesId, @Nullable Long timestampMin, @Nullable Long timestampMax) throws IOException {
        this.timeSeriesDAO.delete(timeSeriesId, timestampMin == null ? null : Instant.ofEpochMilli(timestampMin), timestampMax == null ? null : Instant.ofEpochMilli(timestampMax));
    }

    @Override
    @GHWriteTransaction
    public void deleteOwnersFromTimeSeriesHeads(String owner) throws IOException {
        this.timeSeriesHeadDAO.deleteOwnersFromTimeSeriesHeads(owner);
    }
}

