/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.AuthorizationMatrix;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.model.PublicUser;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorizationMatrixBuilder {
    @Autowired
    private UsersService usersService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private LimitsStatusComputer.LicenseLimitsStatus lls;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.authorizationmatrix");

    public AuthorizationMatrixBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public AuthorizationMatrix compute() throws Exception {
        AuthorizationMatrix ret = new AuthorizationMatrix();
        List<UsersDAO.User> allUsers = this.usersService.listUsersInternalUnsafeEnabledOnly();
        ret.perUser = this.computePerUser(allUsers);
        ret.perGroup = this.computePerGroup();
        return ret;
    }

    public AuthorizationMatrix.PerUser computePerUser(Collection<UsersDAO.User> users) throws IOException {
        if (this.lls == null) {
            this.lls = this.licenseEnforcementService.getLimitsStatus();
        }
        AuthorizationMatrix.PerUser perUser = new AuthorizationMatrix.PerUser();
        ArrayList<GHAuthCtx> lius = new ArrayList<GHAuthCtx>();
        perUser.users = new ArrayList<PublicUser>();
        for (UsersDAO.User u : users) {
            PublicUser pu = new PublicUser();
            pu.login = u.login;
            pu.displayName = u.displayName;
            perUser.users.add(pu);
            GHAuthCtx liu = GHAuthCtx.forUserLogin(u);
            lius.add(liu);
            perUser.setPermissions(liu.getPermissions());
        }
        return perUser;
    }

    private AuthorizationMatrix.PerGroup computePerGroup() throws IOException {
        AuthorizationMatrix.PerGroup perGroup = new AuthorizationMatrix.PerGroup();
        List<UsersDAO.Group> groups = this.usersDAO.listGroupsUnsafe();
        perGroup.groups = new ArrayList<String>();
        for (UsersDAO.Group g : groups) {
            perGroup.groups.add(g.name);
            perGroup.setPermissions(g);
        }
        return perGroup;
    }

    public AuthorizationMatrix.PerPendingUserEmail computePerPendingUserEmail() {
        AuthorizationMatrix.PerPendingUserEmail perPendingUserEmail = new AuthorizationMatrix.PerPendingUserEmail();
        HashSet pendingUserEmails = new HashSet();
        perPendingUserEmail.pendingUserEmails = new ArrayList<String>(pendingUserEmails);
        return perPendingUserEmail;
    }
}

