/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;

public class DropRow
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;

    public DropRow(String[] columns) {
        this.columns = columns;
    }

    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public void process(RawObservation data) {
        for (String col : this.columns) {
            Object value = data.get(col);
            if (value != null && (!(value instanceof String) || !((String)value).isEmpty())) continue;
            data.setError("Row was dropped due to missing value for " + col);
            break;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("DropRow(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]);
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

