/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerService;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.distributed.metrics.ContainerUsageMetrics;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public class AnalysisMLContainerKernel
extends AnalysisMLKernel
implements IAnalysisMLKernel {
    public static final int LINK_WAIT_TIMEOUT = 1800000;
    public static final long RESULT_WAIT_TIMEOUT = 1800000L;
    public static final long ERROR_WAIT_TIMEOUT = 10000L;
    private final ContainerExecRuntimeConfig containerConfig;
    private final String identifier;
    private final String executionId;
    private final File testFile;
    private final File errorFile;
    private final File contextDir;
    private KubernetesExecUtils.KubernetesPod kubernetesPod;
    private final JsonObject additionalProperties = new JsonObject();
    private final ComputeResourceUsage cru = new ComputeResourceUsage();
    private String pythonModule = "dataiku.doctor.server";
    private RemoteRunsRegistry.ExecutionType executionType = RemoteRunsRegistry.ExecutionType.DOCTOR_PYTHON;
    private AnalysisMLContainerStatus status = AnalysisMLContainerStatus.PENDING;

    public AnalysisMLContainerKernel(SingleCommandKernelLink link, WorkSet.PreprocessingSet pps, String projectKey, String envName, AuthCtx authCtx, File workDir, File contextDir, ContainerExecRuntimeConfig containerConfig, String executionIdBase) throws FileNotFoundException {
        super(link, pps, projectKey, envName, authCtx, workDir, ((WorkerService)SpringUtils.getBean(WorkerService.class)).createWorkerPool(projectKey, envName, authCtx, containerConfig, true, true, null));
        this.identifier = SecretKeyGenerator.generateSmall();
        this.executionId = KubernetesExecUtils.getNormalizedExecutionId(executionIdBase + this.identifier);
        this.containerConfig = containerConfig;
        this.contextDir = contextDir;
        this.testFile = new File(workDir, "container_done.txt");
        this.errorFile = new File(workDir, "error.json");
    }

    @Override
    public void start() throws Exception {
        assert (StringUtils.isEmpty((String)this.resourceFolderPath));
        if (this.testFile.exists()) {
            DKUFileUtils.delete((File)this.testFile);
        }
        JsonObject definition = new JsonObject();
        for (Map.Entry props : this.additionalProperties.entrySet()) {
            definition.add((String)props.getKey(), (JsonElement)props.getValue());
        }
        definition.addProperty("port", (Number)((SingleCommandKernelLink)this.link).getPort());
        definition.addProperty("secret", ((SingleCommandKernelLink)this.link).getSecret());
        String contextDirAbsolutePath = this.contextDir.getAbsolutePath();
        String workDirAbsolutePath = this.workDir.getAbsolutePath();
        definition.addProperty("module", this.pythonModule);
        definition.addProperty("server_cert", EncryptedRPC.getPEMCertificateTextB64orNA());
        JsonObject payload = new JsonObject();
        String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(this.envName, CodeEnvModel.EnvLang.PYTHON, this.projectKey);
        CodeEnvModel.EnvFullRef envRef = new CodeEnvModel.EnvFullRef(CodeEnvModel.EnvLang.PYTHON, this.envName, envVersion);
        RemoteRunsRegistry.add(this.executionId, this.authCtx, this.projectKey, contextDirAbsolutePath, workDirAbsolutePath, this.executionType, definition.toString(), payload.toString(), Collections.singletonList(contextDirAbsolutePath), Collections.singletonList(workDirAbsolutePath), Collections.singletonList(envRef));
        this.addOnShutdown(new Runnable(){

            @Override
            public void run() {
                RemoteRunsRegistry.remove(AnalysisMLContainerKernel.this.executionId);
            }
        });
        this.createTicket(this.identifier);
        String imageTag = ContainerExecImagesHelper.getImageTagToUse(this.containerConfig.dockerHost, this.containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, CodeEnvModel.EnvLang.PYTHON, this.envName, envVersion);
        imageTag = ContainerExecImagesHelper.withRepositoryURL(this.containerConfig, imageTag);
        switch (this.containerConfig.type) {
            case DOCKER: {
                final String containerName = "dku_exec-" + this.executionId;
                this.kernelEnvVariables.put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
                this.kernelEnvVariables.put("DKU_API_TICKET", this.ticket.getSecret());
                this.kernelEnvVariables.putAll(this.forcedEnvVars);
                final ProcessBuilder pb = new ProcessBuilder(DockerExecUtils.getDockerRunCommand(this.authCtx, RemoteRunsRegistry.ExecutionType.DOCTOR_PYTHON, this.projectKey, null, null, this.containerConfig, "--name", containerName));
                pb.command().addAll(DockerExecUtils.getEnvironmentCommandFlags(this.containerConfig));
                pb.command().addAll(DockerExecUtils.formatEnvironmentFlags(this.kernelEnvVariables));
                pb.command().add(imageTag);
                pb.command().add(this.executionId);
                ContainerExecUtils.enrichDockerEnv(this.containerConfig, pb.environment());
                pb.directory(this.workDir);
                this.process = new RegularProcess(pb, this.workDir){

                    public void niceKill() throws IOException {
                        ContainerExecUtils.killDockerContainer(containerName, false, pb.environment(), AnalysisMLContainerKernel.this.logger);
                    }

                    public void evilKill() throws IOException {
                        ContainerExecUtils.killDockerContainer(containerName, true, pb.environment(), AnalysisMLContainerKernel.this.logger);
                        super.evilKill();
                    }
                };
                break;
            }
            case KUBERNETES: {
                File secretFile = new File(this.workDir, "secret.yaml");
                File podFile = new File(this.workDir, "pod.yaml");
                this.kernelEnvVariables.put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
                this.kernelEnvVariables.putAll(this.forcedEnvVars);
                String k8sClusterId = new ClusterSelector().getClusterForProject(this.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
                K8SAPIDeploymentInfra.K8SContainerLimits containerLimits = this.containerConfig.kubernetesResources;
                this.cru.setupSingleK8SJob(k8sClusterId, this.executionId, Double.valueOf(containerLimits.cpuRequest), Double.valueOf(containerLimits.cpuLimit), Integer.valueOf(containerLimits.memRequestMB), Integer.valueOf(containerLimits.memLimitMB), this.containerConfig.name);
                KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, this.executionId, this.containerConfig);
                String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.ticket.getSecret());
                String podDesc = KubernetesExecUtils.getPodConf(this.authCtx, this.executionId, this.projectKey, "NA", this.identifier, laa, this.kernelEnvVariables, imageTag, this.containerConfig);
                String podName = KubernetesExecUtils.getPodName(this.executionId);
                DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
                DKUFileUtils.writeFileUTF8((File)podFile, (String)podDesc);
                this.kubernetesPod = new KubernetesExecUtils.KubernetesPod(this.authCtx, this.projectKey, podName, this.containerConfig, secretFile, podFile);
                this.process = this.kubernetesPod;
                this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)this.kubernetesPod.getErrorSniffer());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)this.containerConfig.type));
            }
        }
        this.process.start();
        this.startStandardTailers();
        switch (this.containerConfig.type) {
            case DOCKER: {
                this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
                break;
            }
            case KUBERNETES: {
                this.monitorThread = new K8SKernelMonitorThread();
            }
        }
        this.monitorThread.setCloseOnFailure((Closeable)((SingleCommandKernelLink)this.link).getServerSocket());
        try {
            this.cru.reportStartNoFail();
            this.monitorThread.start();
            ((SingleCommandKernelLink)this.link).waitForProcess(1800000);
            this.status = AnalysisMLContainerStatus.READY;
        }
        catch (SocketBlockLink.SecretKernelTimeoutException e) {
            IOException sniffed;
            this.status = AnalysisMLContainerStatus.DEAD;
            if (this.kubernetesPod != null && (sniffed = this.kubernetesPod.getSniffedException()) != null) {
                throw sniffed;
            }
            throw e;
        }
        finally {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    public IOException maybeRethrowAsProcessDied(IOException e) {
        this.status = AnalysisMLContainerStatus.DEAD;
        if (this.containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER) {
            return super.maybeRethrowAsProcessDied(e);
        }
        IsolableProcess process = this.process;
        if (process == null) {
            this.logger.info((Object)"Kubernetes: process was cleaned up by monitoring thread");
            this.logger.info((Object)("Kubernetes: Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " retcode=" + this.savedReturnCode));
        } else {
            this.logger.info((Object)("Kubernetes: Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " process=" + String.valueOf(process) + " pid=" + process.getWorkingPid() + " retcode=" + this.savedReturnCode));
        }
        if (e instanceof EOFException || e.getCause() instanceof EOFException) {
            Integer returnCode = null;
            for (int i = 0; i < 20; ++i) {
                this.logger.debug((Object)"Trying to enrich exception, still waiting for job to complete ...");
                DKUtils.unsafeSleep((long)1000L);
                returnCode = this.savedReturnCode;
                if (returnCode != null) break;
            }
            if (returnCode != null && returnCode != 0) {
                return new ProcessDiedException("Kubernetes pod failed: " + ExceptionUtils.getMessageWithCauses((Throwable)this.processExitException), this.getLogTail(), null, returnCode.intValue());
            }
            this.logger.warn((Object)"Still did not get a return code after EOF exception");
            return e;
        }
        return e;
    }

    @Override
    public void setPythonModule(String pythonModule) {
        this.pythonModule = pythonModule;
    }

    @Override
    public void waitForResults() throws Exception {
        if (this.abort) {
            this.logger.warn((Object)"Waiting for results on aborted Kernel");
        }
        this.logger.info((Object)"Waiting for results after job finished");
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (!this.abort && !this.testFile.isFile()) {
            if (stopwatch.elapsed(TimeUnit.MILLISECONDS) > 1800000L) {
                throw new TimeoutException("Kernel took more than 1800 seconds to send the results");
            }
            this.logger.info((Object)(String.valueOf(this.testFile) + " not here, still waiting"));
            this.waitForShutdownNoException(2000L);
            Thread.sleep(500L);
        }
    }

    @Override
    public SerializedError waitForError() throws Exception {
        if (this.abort) {
            this.logger.warn((Object)"Waiting for error on aborted Kernel");
        }
        this.logger.info((Object)"Waiting for error after pod failed");
        long start = System.currentTimeMillis();
        while (!(this.abort || this.errorFile.isFile() || this.testFile.isFile() || System.currentTimeMillis() - start >= 10000L)) {
            this.logger.info((Object)(String.valueOf(this.errorFile) + " not here, still waiting"));
            this.waitForShutdownNoException(2000L);
            Thread.sleep(500L);
        }
        if (this.errorFile.isFile()) {
            this.logger.info((Object)"Got error file");
            try {
                return (SerializedError)JSON.parseFile((File)this.errorFile, SerializedError.class);
            }
            catch (Exception e) {
                this.logger.error((Object)("Could not read error file " + String.valueOf(this.errorFile)), (Throwable)e);
            }
        } else {
            this.logger.info((Object)"Didn't get error file");
        }
        return null;
    }

    @Override
    public void cleanup() throws Exception {
        if (this.containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            try {
                this.logger.info((Object)"Deleting pod");
                this.kubernetesPod.delete(false);
                this.logger.info((Object)"Pod deleted");
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while deleting pod", (Throwable)e);
            }
        }
    }

    public void setExecutionType(RemoteRunsRegistry.ExecutionType executionType) {
        this.executionType = executionType;
    }

    public JsonObject getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ContainerUsageMetrics getContainerUsageMetrics() {
        ContainerUsageMetrics containerUsageMetrics = new ContainerUsageMetrics(0, 0, 0, this.containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES);
        switch (this.status) {
            case DEAD: {
                containerUsageMetrics.incrementDead();
                break;
            }
            case PENDING: {
                containerUsageMetrics.incrementPending();
                break;
            }
            case READY: {
                containerUsageMetrics.incrementReady();
            }
        }
        if (this.workerPool != null) {
            containerUsageMetrics = containerUsageMetrics.add(this.workerPool.getWorkersUsageMetrics());
        }
        return containerUsageMetrics;
    }

    public static enum AnalysisMLContainerStatus {
        PENDING,
        READY,
        DEAD;

    }

    protected class K8SKernelMonitorThread
    extends DSSKernelBase.KernelMonitorThread {
        protected K8SKernelMonitorThread() {
            super((DSSKernelBase)AnalysisMLContainerKernel.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("KNL-" + AnalysisMLContainerKernel.this.id + "-k8smonitor-" + Thread.currentThread().getId());
            try {
                AnalysisMLContainerKernel.this.outputConsumer.start(AnalysisMLContainerKernel.this.process.getInputStream(), AnalysisMLContainerKernel.this.process.getErrorStream(), AnalysisMLContainerKernel.this.process.getOutputStream());
                AnalysisMLContainerKernel.this.logger.info((Object)"Waiting for K8S pod termination");
                Object k8sPodException = KubernetesExecUtils.waitForPod(AnalysisMLContainerKernel.this.authCtx, AnalysisMLContainerKernel.this.projectKey, KubernetesExecUtils.getPodName(AnalysisMLContainerKernel.this.executionId), AnalysisMLContainerKernel.this.containerConfig, null);
                AnalysisMLContainerKernel.this.logger.info((Object)("K8S pod terminated, exception:" + String.valueOf(k8sPodException)));
                int logHandlerReturnValue = AnalysisMLContainerKernel.this.process.waitFor();
                AnalysisMLContainerKernel.this.logger.info((Object)("Log handling process done with code " + logHandlerReturnValue));
                AnalysisMLContainerKernel.this.processExitException = k8sPodException;
                AnalysisMLContainerKernel analysisMLContainerKernel = AnalysisMLContainerKernel.this;
                synchronized (analysisMLContainerKernel) {
                    if (k8sPodException == null) {
                        AnalysisMLContainerKernel.this.savedReturnCode = 0;
                    } else {
                        AnalysisMLContainerKernel.this.savedReturnCode = 1;
                    }
                    AnalysisMLContainerKernel.this.process = null;
                }
                AnalysisMLContainerKernel.this.tryUnregisterHook();
                AnalysisMLContainerKernel.this.outputConsumer.finish();
            }
            catch (Exception e) {
                AnalysisMLContainerKernel.this.logger.error((Object)"Failure while monitoring K8S pod", (Throwable)e);
            }
            finally {
                AnalysisMLContainerKernel.this.cru.reportCompleteNoFail();
                K8SKernelMonitorThread k8SKernelMonitorThread = this;
                synchronized (k8SKernelMonitorThread) {
                    if (this.toInterrupt != null) {
                        AnalysisMLContainerKernel.this.logger.info((Object)("K8SKernelMonitorThread done: Interrupting : " + String.valueOf(this.toInterrupt)));
                        this.toInterrupt.interrupt();
                    }
                    if (this.toClose != null) {
                        AnalysisMLContainerKernel.this.logger.error((Object)("K8SKernelMonitorThread done:  Closing: " + String.valueOf(this.toClose)));
                        IOUtils.closeQuietly((Closeable)this.toClose);
                    }
                }
            }
        }
    }
}

