/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.Arrays;

public class IsStatisticalTimeseriesModel
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        PostTrainModelingParams resolvedParams = timeseriesModelDetails.actualParams.resolved;
        if (!(resolvedParams instanceof PostTrainPredictionModelingParams)) {
            throw new IOException(String.format("Extractor '%s' does not support PostTrainModelingParams of type '%s'", this.getClass().getSimpleName(), resolvedParams.getClass().getSimpleName()));
        }
        PostTrainPredictionModelingParams predictionModelingParams = (PostTrainPredictionModelingParams)resolvedParams;
        if (Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA, PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS, PreTrainPredictionModelingParams.Algorithm.PROPHET).contains((Object)predictionModelingParams.algorithm)) {
            return "Yes";
        }
        return "No";
    }
}

