/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.hf;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component
public class ModelCacheDataProvider {
    private static final File MODEL_CACHE_ROOT_DIRECTORY = DKUApp.getFile((String[])new String[]{"model_cache", "hf"});
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.modelcache");

    public NativeFS getCacheData() throws IOException {
        if (!MODEL_CACHE_ROOT_DIRECTORY.isDirectory()) {
            logger.info((Object)("Creating model cache data store: " + MODEL_CACHE_ROOT_DIRECTORY.getPath()));
            DKUFileUtils.mkdirs((File)MODEL_CACHE_ROOT_DIRECTORY);
        }
        return NativeFS.from((File)MODEL_CACHE_ROOT_DIRECTORY).skipFileTypeCheck(false).atomicWrite(true).build();
    }

    public static boolean isWithinModelCacheFollowLinks(File file) throws IOException {
        return DKUFileUtils.isWithinFollowLinks((File)MODEL_CACHE_ROOT_DIRECTORY, (File)file);
    }
}

