/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.AbstractTrainingRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSplitService;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.core.TrainExecutionParams;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPredictionTrainingRecipeRunner
extends AbstractTrainingRecipeRunner {
    @Autowired
    protected PredictionSplitService predictionSplitService;

    public AbstractPredictionTrainingRecipeRunner(JobActivity activity) {
        super(activity);
    }

    protected PostTrainModelingParams updateTrainInfoWithPostSearchDescription(File outModelFolder, ModelTrainInfo mti, PreTrainModelingParams modeling) throws IOException {
        ActualModelParameters amp = (ActualModelParameters)JSON.parseFile((File)new File(outModelFolder, "actual_params.json"), ActualModelParameters.class);
        PostTrainModelingParams resolved = amp.resolved;
        mti.postSearchDescription = resolved.generatePostSearchDescription(mti.preSearchDescription, modeling);
        JSON.prettyToFile((Object)mti, (File)new File(outModelFolder, "train_info.json"));
        return resolved;
    }

    protected void addEnvParameters(AbstractPredictionTrainingRecipePayloadParams desc, ResolvedPredictionCoreParams coreParams, ContainerExecSelection containerSelection) {
        if (coreParams.executionParams == null) {
            coreParams.executionParams = new TrainExecutionParams();
        }
        coreParams.executionParams.containerSelection = containerSelection;
        coreParams.executionParams.envSelection = desc.envSelection;
        coreParams.executionParams.envName = desc.envName;
        if (coreParams.backendType == null) {
            coreParams.backendType = desc.backendType;
        }
    }
}

