/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.coremodel.Schema;
import com.google.common.base.Strings;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SplitDesc {
    public SplitParams params;
    public ClusteringMLTask.ClusterSampling cparams;
    public long generationDate;
    public String policyId;
    public String instanceId;
    public String format;
    public Schema schema;
    public String trainPath;
    public String testPath;
    public String fullPath;
    public long trainRows;
    public long testRows;
    public long fullRows;

    public SplitDesc() {
    }

    public SplitDesc(String policyId, String instanceId, SplitParams params, Schema schema) {
        this.policyId = policyId;
        this.instanceId = instanceId;
        this.schema = schema;
        this.params = params;
        this.format = "csv1";
        this.generationDate = System.currentTimeMillis();
    }

    public SplitDesc(String policyId, String instanceId, ClusteringMLTask.ClusterSampling cparams, Schema schema) {
        this.policyId = policyId;
        this.instanceId = instanceId;
        this.schema = schema;
        this.cparams = cparams;
        this.format = "csv1";
        this.generationDate = System.currentTimeMillis();
    }

    public Set<String> getNonEmptySplitPaths() {
        return Stream.of(this.trainPath, this.testPath, this.fullPath).filter(path -> !Strings.isNullOrEmpty((String)path)).collect(Collectors.toSet());
    }

    public static class SplitRef {
        public String splitInstanceId;

        public SplitRef(String splitInstanceId) {
            this.splitInstanceId = splitInstanceId;
        }
    }
}

