/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.split.EFSDSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.EFTDSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.PredictionSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.RandomSingleDatasetSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SingleDatasetFullSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SortedSingleDatasetSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.StratifiedSplitGenerator;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.Collections;

public class SplitGeneratorFactory {
    public static PredictionSplitGenerator buildForMLTask(AnalysisCoreParams acp, MLTaskLoc taskLoc, SplitParams params, AuthCtx user) {
        PredictionSplitGenerator ret = null;
        acp.script.contextProjectKey = taskLoc.analysisProjectKey;
        switch (params.ttPolicy) {
            case SPLIT_SINGLE_DATASET: {
                if (params.kfold && params.ssdSplitMode == SplitParams.SplitMode.RANDOM || params.streamAll) {
                    ret = new SingleDatasetFullSplitGenerator(taskLoc, acp, params, user);
                    break;
                }
                if (params.ssdSplitMode == SplitParams.SplitMode.RANDOM) {
                    ret = new RandomSingleDatasetSplitGenerator(taskLoc, acp, params, user);
                    break;
                }
                if (params.ssdSplitMode == SplitParams.SplitMode.SORTED) {
                    ret = new SortedSingleDatasetSplitGenerator(taskLoc, acp, params, user);
                    break;
                }
                throw new NotImplementedException();
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                ret = new EFTDSplitGenerator(taskLoc, acp, params, user);
                break;
            }
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                ret = new EFSDSplitGenerator(taskLoc, acp, params, user);
            }
        }
        SpringUtils.getInstance().autowire(ret);
        return ret;
    }

    public static PredictionSplitGenerator buildForPartitionedMLTask(AnalysisCoreParams acp, MLTaskLoc taskLoc, SplitParams params, AuthCtx user, String partition, Schema baseSplitSchema) {
        if (params.ttPolicy != SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET) {
            throw new NotImplementedException("Unsupported train/test policy for partitioned MLTask: " + String.valueOf((Object)params.ttPolicy));
        }
        SplitParams partitionSplitParams = (SplitParams)JSON.deepCopy((Object)params);
        if (partition != null) {
            partitionSplitParams.ssdSelection.withSelectedPartitionIds(Collections.singletonList(partition));
        }
        StratifiedSplitGenerator splitGenerator = new StratifiedSplitGenerator(SplitGeneratorFactory.buildForMLTask(acp, taskLoc, partitionSplitParams, user), partition, baseSplitSchema);
        SpringUtils.getInstance().autowire((Object)splitGenerator);
        return splitGenerator;
    }
}

