/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.algorithms.ClusteringAlgorithmMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.IsolationForestMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.TwoStepMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.CustomScikitModel;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.DBScanMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.HDBScanMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.MiniBatchKmeansMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.PyGMMMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.PyKMeansMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.SpectralMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.WardMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.MLLibCustomMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.MLLibGMMMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.MLLibKMeansMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.SparklingKMeansMeta;
import com.dataiku.dip.analysis.model.clustering.algorithms.vertica.VerticaKMeansMeta;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;

public class PreTrainClusteringModelingParams
implements PreTrainModelingParams {
    public Algorithm algorithm;
    public int k;
    public int n_jobs = 2;
    public int max_iterations;
    public double epsilon;
    public double min_sample_ratio;
    public double min_cluster_size_ratio;
    public boolean allow_sparse_matrices;
    public Integer n_init;
    public double gamma;
    public double coef0;
    public String affinity;
    public Integer seed;
    public String init;
    public String scikit_clf;
    public String custom_model_name;
    public boolean custom_has_k;
    public PredictionModelingParams.MLLibCustomGridParams mllib_custom;
    public ClusteringModelingParams.IsolationForestParams isolation_forest = new ClusteringModelingParams.IsolationForestParams();
    public int ts_kmeans_k;
    public ClusteringModelingParams.MetricParams metrics = new ClusteringModelingParams.MetricParams();

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription() {
        return null;
    }

    @Override
    public String generateName() {
        return this.algorithm.meta.generateName(this);
    }

    @Override
    public String getEvaluationMetricName() {
        return this.metrics.evaluationMetric.toString();
    }

    public PreTrainClusteringModelingParams() {
    }

    public PreTrainClusteringModelingParams(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public static enum Algorithm {
        KMEANS(new PyKMeansMeta()),
        MiniBatchKMeans(new MiniBatchKmeansMeta()),
        SPECTRAL(new SpectralMeta()),
        WARD(new WardMeta()),
        DBSCAN(new DBScanMeta()),
        HDBSCAN(new HDBScanMeta()),
        GMM(new PyGMMMeta()),
        SCIKIT_MODEL(new CustomScikitModel()),
        PY_TWO_STEP(new TwoStepMeta(MLTask.BackendType.PY_MEMORY)),
        PY_ISOLATION_FOREST(new IsolationForestMeta(MLTask.BackendType.PY_MEMORY)),
        MLLIB_KMEANS(new MLLibKMeansMeta()),
        MLLIB_GAUSSIAN_MIXTURE(new MLLibGMMMeta()),
        MLLIB_CUSTOM(new MLLibCustomMeta()),
        MLLIB_TWO_STEP(new TwoStepMeta(MLTask.BackendType.MLLIB)),
        MLLIB_ISOLATION_FOREST(new IsolationForestMeta(MLTask.BackendType.MLLIB)),
        VERTICA_KMEANS(new VerticaKMeansMeta()),
        SPARKLING_KMEANS(new SparklingKMeansMeta());

        public final MLTask.BackendType backendType;
        public final ClusteringAlgorithmMeta meta;

        private Algorithm(ClusteringAlgorithmMeta meta) {
            this.backendType = meta.backendType();
            this.meta = meta;
        }
    }
}

