/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.FeatureUtils;
import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.prediction.IntegerHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.NumericalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.OddIntegerHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;
import java.util.List;

public class PredictionParameterChecks
extends ParameterChecks {
    private final PredictionModelingParams modelingParams;
    private final PreprocessingParams preprocessingParams;
    private final List<String> verySparseFeatures;
    private final List<String> quiteSparseFeatures;

    public PredictionParameterChecks(PredictionModelingParams modeling, PreprocessingParams preprocessing) {
        this.modelingParams = modeling;
        this.preprocessingParams = preprocessing;
        this.verySparseFeatures = FeatureUtils.getVerySparseFeatures(preprocessing);
        this.quiteSparseFeatures = FeatureUtils.getQuiteSparseFeatures(preprocessing);
    }

    public <T extends Number> void checkNumericalDimension(NumericalHyperparameterDimension<T> dimension, String dimensionName) {
        if (this.isRange(dimension)) {
            this.checkRange(dimension, dimensionName);
        } else {
            this.checkExplicit(dimension, dimensionName);
        }
    }

    private <T extends Number> boolean isRange(NumericalHyperparameterDimension<T> dimension) {
        boolean isGridSearch;
        boolean bl = isGridSearch = this.modelingParams.gridSearchParams.strategy == PredictionModelingParams.GridSearchParams.Strategy.GRID;
        if (isGridSearch) {
            return dimension.gridMode == NumericalHyperparameterDimension.ValueMode.RANGE;
        }
        return dimension.randomMode == NumericalHyperparameterDimension.ValueMode.RANGE;
    }

    private <T extends Number> void checkRange(NumericalHyperparameterDimension<T> dimension, String dimensionName) {
        ErrorContext.check((dimension.range != null ? 1 : 0) != 0, (String)("Range is null for hyperparameter \"" + dimensionName + "\""));
        ErrorContext.check((dimension.range.min != null ? 1 : 0) != 0, (String)("Min of range is null for hyperparameter \"" + dimensionName + "\""));
        ErrorContext.check((dimension.range.max != null ? 1 : 0) != 0, (String)("Max of range is null for hyperparameter \"" + dimensionName + "\""));
        ErrorContext.check((((Number)dimension.range.min).doubleValue() <= ((Number)dimension.range.max).doubleValue() ? 1 : 0) != 0, (String)("Range is invalid for hyperparameter \"" + dimensionName + "\": max < min"));
        if (dimension.limit.min != null) {
            ErrorContext.check((((Number)dimension.limit.min).doubleValue() <= ((Number)dimension.range.min).doubleValue() ? 1 : 0) != 0, (String)("Range is invalid for hyperparameter \"" + dimensionName + "\": min < limit"));
        }
        if (dimension.limit.max != null) {
            ErrorContext.check((((Number)dimension.limit.max).doubleValue() >= ((Number)dimension.range.max).doubleValue() ? 1 : 0) != 0, (String)("Range is invalid for hyperparameter \"" + dimensionName + "\": max > limit"));
        }
        if (dimension.range.scaling == NumericalHyperparameterDimension.Scaling.LOGARITHMIC) {
            ErrorContext.check((((Number)dimension.range.min).doubleValue() > 0.0 ? 1 : 0) != 0, (String)("Range is invalid for hyperparameter \"" + dimensionName + "\": min <= 0 is incompatible with logarithmic scaling"));
        }
        if (this.modelingParams.gridSearchParams.strategy == PredictionModelingParams.GridSearchParams.Strategy.GRID && dimension.gridMode == NumericalHyperparameterDimension.ValueMode.RANGE) {
            ErrorContext.check((dimension.range.nbValues != null ? 1 : 0) != 0, (String)("Values count is null for hyperparameter \"" + dimensionName + "\""));
            ErrorContext.check((dimension.range.nbValues >= 2 ? 1 : 0) != 0, (String)("Values count is less than 2 for hyperparameter \"" + dimensionName + "\""));
            if (dimension instanceof IntegerHyperparameterDimension) {
                if (dimension instanceof OddIntegerHyperparameterDimension) {
                    Long maxNbValues = (long)Math.floor((double)(((Number)dimension.range.max).longValue() - ((Number)dimension.range.min).longValue()) / 2.0) + 1L;
                    ErrorContext.check(((long)dimension.range.nbValues.intValue() <= maxNbValues ? 1 : 0) != 0, (String)("Values count exceeds " + maxNbValues + " ([(max - min)/2] + 1) for odd integer hyperparameter \"" + dimensionName + "\""));
                } else {
                    Long maxNbValues = ((Number)dimension.range.max).longValue() - ((Number)dimension.range.min).longValue() + 1L;
                    ErrorContext.check(((long)dimension.range.nbValues.intValue() <= maxNbValues ? 1 : 0) != 0, (String)("Values count exceeds " + maxNbValues + " (max - min + 1) for integer hyperparameter \"" + dimensionName + "\""));
                }
            }
        }
    }

    private <T extends Number> void checkExplicit(NumericalHyperparameterDimension<T> dimension, String dimensionName) {
        ErrorContext.check((dimension.values != null ? 1 : 0) != 0, (String)("Explicit values list is null for hyperparameter \"" + dimensionName + "\""));
        ErrorContext.check((dimension.values.length != 0 ? 1 : 0) != 0, (String)("Explicit values list is empty for hyperparameter \"" + dimensionName + "\""));
        if (dimension.limit.min != null) {
            ErrorContext.check((((Number)dimension.limit.min).doubleValue() <= ((Number)dimension.getMinValue()).doubleValue() ? 1 : 0) != 0, (String)("Invalid explicit values for hyperparameter \"" + dimensionName + "\": min < limit"));
        }
        if (dimension.limit.max != null) {
            ErrorContext.check((((Number)dimension.limit.max).doubleValue() >= ((Number)dimension.getMaxValue()).doubleValue() ? 1 : 0) != 0, (String)("Invalid explicit values for hyperparameter \"" + dimensionName + "\": max > limit"));
        }
        if (dimension instanceof OddIntegerHyperparameterDimension) {
            Long[] longArray = (Long[])((OddIntegerHyperparameterDimension)dimension).values;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long value = longArray[i];
                ErrorContext.check((value % 2L != 0L ? 1 : 0) != 0, (String)("Invalid explicit value (" + value + ") for odd integer hyperparameter \"" + dimensionName + "\""));
            }
        }
    }

    public void checkNoNumericalFeatures(String msg) {
        for (FeaturePreprocessingParams e : this.preprocessingParams.per_feature.values()) {
            ErrorContext.check((e.role == FeaturePreprocessingParams.Role.REJECT || e.role == FeaturePreprocessingParams.Role.TARGET || e.type != FeaturePreprocessingParams.FeatureType.NUMERIC ? 1 : 0) != 0, (String)msg);
        }
    }

    public void addWarningSparse(String algo) {
        if (!this.verySparseFeatures.isEmpty()) {
            this.addWarning("Unsupported sparse features", "You have selected handling methods for some features that will create an extremely large number of sparse columns, but the " + algo + " algorithm does not support these. Memory overruns may happen");
        } else if (!this.quiteSparseFeatures.isEmpty()) {
            this.addWarning("Unsupported sparse features", "You have selected handling methods for some features that may create a large number of sparse columns, but the " + algo + " algorithm does not support these. Memory overruns may happen");
        }
    }
}

